// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.servicebus.fluent.models.PremiumMessagingRegionInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The response of the List PremiumMessagingRegions operation. */
@Fluent
public final class PremiumMessagingRegionsListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(PremiumMessagingRegionsListResult.class);

    /*
     * Result of the List PremiumMessagingRegions type.
     */
    @JsonProperty(value = "value")
    private List<PremiumMessagingRegionInner> value;

    /*
     * Link to the next set of results. Not empty if Value contains incomplete
     * list of PremiumMessagingRegions.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /**
     * Get the value property: Result of the List PremiumMessagingRegions type.
     *
     * @return the value value.
     */
    public List<PremiumMessagingRegionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Result of the List PremiumMessagingRegions type.
     *
     * @param value the value value to set.
     * @return the PremiumMessagingRegionsListResult object itself.
     */
    public PremiumMessagingRegionsListResult withValue(List<PremiumMessagingRegionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of
     * PremiumMessagingRegions.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
