// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Represents a filter which is a composition of an expression and an action that is executed in the pub/sub pipeline.
 */
@Fluent
public final class SqlFilter {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SqlFilter.class);

    /*
     * The SQL expression. e.g. MyProperty='ABC'
     */
    @JsonProperty(value = "sqlExpression")
    private String sqlExpression;

    /*
     * This property is reserved for future use. An integer value showing the
     * compatibility level, currently hard-coded to 20.
     */
    @JsonProperty(value = "compatibilityLevel")
    private Integer compatibilityLevel;

    /*
     * Value that indicates whether the rule action requires preprocessing.
     */
    @JsonProperty(value = "requiresPreprocessing")
    private Boolean requiresPreprocessing;

    /**
     * Get the sqlExpression property: The SQL expression. e.g. MyProperty='ABC'.
     *
     * @return the sqlExpression value.
     */
    public String sqlExpression() {
        return this.sqlExpression;
    }

    /**
     * Set the sqlExpression property: The SQL expression. e.g. MyProperty='ABC'.
     *
     * @param sqlExpression the sqlExpression value to set.
     * @return the SqlFilter object itself.
     */
    public SqlFilter withSqlExpression(String sqlExpression) {
        this.sqlExpression = sqlExpression;
        return this;
    }

    /**
     * Get the compatibilityLevel property: This property is reserved for future use. An integer value showing the
     * compatibility level, currently hard-coded to 20.
     *
     * @return the compatibilityLevel value.
     */
    public Integer compatibilityLevel() {
        return this.compatibilityLevel;
    }

    /**
     * Set the compatibilityLevel property: This property is reserved for future use. An integer value showing the
     * compatibility level, currently hard-coded to 20.
     *
     * @param compatibilityLevel the compatibilityLevel value to set.
     * @return the SqlFilter object itself.
     */
    public SqlFilter withCompatibilityLevel(Integer compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
        return this;
    }

    /**
     * Get the requiresPreprocessing property: Value that indicates whether the rule action requires preprocessing.
     *
     * @return the requiresPreprocessing value.
     */
    public Boolean requiresPreprocessing() {
        return this.requiresPreprocessing;
    }

    /**
     * Set the requiresPreprocessing property: Value that indicates whether the rule action requires preprocessing.
     *
     * @param requiresPreprocessing the requiresPreprocessing value to set.
     * @return the SqlFilter object itself.
     */
    public SqlFilter withRequiresPreprocessing(Boolean requiresPreprocessing) {
        this.requiresPreprocessing = requiresPreprocessing;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
