/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.servicebus.implementation.DurationSerializer;
import com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.azure.resourcemanager.servicebus.models.MessageCountDetails;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Duration;
import java.time.OffsetDateTime;

@JsonFlatten
public class SBSubscriptionInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SBSubscriptionInner.class);
    @JsonProperty(value="properties.messageCount", access=JsonProperty.Access.WRITE_ONLY)
    private Long messageCount;
    @JsonProperty(value="properties.createdAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdAt;
    @JsonProperty(value="properties.accessedAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime accessedAt;
    @JsonProperty(value="properties.updatedAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime updatedAt;
    @JsonProperty(value="properties.countDetails", access=JsonProperty.Access.WRITE_ONLY)
    private MessageCountDetails countDetails;
    @JsonProperty(value="properties.lockDuration")
    @JsonSerialize(using=DurationSerializer.class)
    private Duration lockDuration;
    @JsonProperty(value="properties.requiresSession")
    private Boolean requiresSession;
    @JsonProperty(value="properties.defaultMessageTimeToLive")
    @JsonSerialize(using=DurationSerializer.class)
    private Duration defaultMessageTimeToLive;
    @JsonProperty(value="properties.deadLetteringOnFilterEvaluationExceptions")
    private Boolean deadLetteringOnFilterEvaluationExceptions;
    @JsonProperty(value="properties.deadLetteringOnMessageExpiration")
    private Boolean deadLetteringOnMessageExpiration;
    @JsonProperty(value="properties.duplicateDetectionHistoryTimeWindow")
    @JsonSerialize(using=DurationSerializer.class)
    private Duration duplicateDetectionHistoryTimeWindow;
    @JsonProperty(value="properties.maxDeliveryCount")
    private Integer maxDeliveryCount;
    @JsonProperty(value="properties.status")
    private EntityStatus status;
    @JsonProperty(value="properties.enableBatchedOperations")
    private Boolean enableBatchedOperations;
    @JsonProperty(value="properties.autoDeleteOnIdle")
    @JsonSerialize(using=DurationSerializer.class)
    private Duration autoDeleteOnIdle;
    @JsonProperty(value="properties.forwardTo")
    private String forwardTo;
    @JsonProperty(value="properties.forwardDeadLetteredMessagesTo")
    private String forwardDeadLetteredMessagesTo;

    public Long messageCount() {
        return this.messageCount;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public OffsetDateTime accessedAt() {
        return this.accessedAt;
    }

    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public MessageCountDetails countDetails() {
        return this.countDetails;
    }

    public Duration lockDuration() {
        return this.lockDuration;
    }

    public SBSubscriptionInner withLockDuration(Duration lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    public Boolean requiresSession() {
        return this.requiresSession;
    }

    public SBSubscriptionInner withRequiresSession(Boolean requiresSession) {
        this.requiresSession = requiresSession;
        return this;
    }

    public Duration defaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public SBSubscriptionInner withDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    public Boolean deadLetteringOnFilterEvaluationExceptions() {
        return this.deadLetteringOnFilterEvaluationExceptions;
    }

    public SBSubscriptionInner withDeadLetteringOnFilterEvaluationExceptions(Boolean deadLetteringOnFilterEvaluationExceptions) {
        this.deadLetteringOnFilterEvaluationExceptions = deadLetteringOnFilterEvaluationExceptions;
        return this;
    }

    public Boolean deadLetteringOnMessageExpiration() {
        return this.deadLetteringOnMessageExpiration;
    }

    public SBSubscriptionInner withDeadLetteringOnMessageExpiration(Boolean deadLetteringOnMessageExpiration) {
        this.deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
        return this;
    }

    public Duration duplicateDetectionHistoryTimeWindow() {
        return this.duplicateDetectionHistoryTimeWindow;
    }

    public SBSubscriptionInner withDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
        this.duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow;
        return this;
    }

    public Integer maxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public SBSubscriptionInner withMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    public EntityStatus status() {
        return this.status;
    }

    public SBSubscriptionInner withStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public Boolean enableBatchedOperations() {
        return this.enableBatchedOperations;
    }

    public SBSubscriptionInner withEnableBatchedOperations(Boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    public Duration autoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public SBSubscriptionInner withAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    public String forwardTo() {
        return this.forwardTo;
    }

    public SBSubscriptionInner withForwardTo(String forwardTo) {
        this.forwardTo = forwardTo;
        return this;
    }

    public String forwardDeadLetteredMessagesTo() {
        return this.forwardDeadLetteredMessagesTo;
    }

    public SBSubscriptionInner withForwardDeadLetteredMessagesTo(String forwardDeadLetteredMessagesTo) {
        this.forwardDeadLetteredMessagesTo = forwardDeadLetteredMessagesTo;
        return this;
    }

    public void validate() {
        if (this.countDetails() != null) {
            this.countDetails().validate();
        }
    }
}

