/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.models;

import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.azure.resourcemanager.servicebus.fluent.models.SBNamespaceInner;
import com.azure.resourcemanager.servicebus.models.NamespaceAuthorizationRules;
import com.azure.resourcemanager.servicebus.models.NamespaceSku;
import com.azure.resourcemanager.servicebus.models.Queues;
import com.azure.resourcemanager.servicebus.models.Topics;
import java.time.OffsetDateTime;

public interface ServiceBusNamespace
extends GroupableResource<ServiceBusManager, SBNamespaceInner>,
Refreshable<ServiceBusNamespace>,
Updatable<Update> {
    public String dnsLabel();

    public String fqdn();

    public NamespaceSku sku();

    public OffsetDateTime createdAt();

    public OffsetDateTime updatedAt();

    public Queues queues();

    public Topics topics();

    public NamespaceAuthorizationRules authorizationRules();

    public static interface UpdateStages {

        public static interface WithAuthorizationRule {
            public Update withNewSendRule(String var1);

            public Update withNewListenRule(String var1);

            public Update withNewManageRule(String var1);

            public Update withoutAuthorizationRule(String var1);
        }

        public static interface WithTopic {
            public Update withNewTopic(String var1, int var2);

            public Update withoutTopic(String var1);
        }

        public static interface WithQueue {
            public Update withNewQueue(String var1, int var2);

            public Update withoutQueue(String var1);
        }

        public static interface WithSku {
            public Update withSku(NamespaceSku var1);
        }
    }

    public static interface Update
    extends Appliable<ServiceBusNamespace>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithSku,
    UpdateStages.WithQueue,
    UpdateStages.WithTopic,
    UpdateStages.WithAuthorizationRule {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<ServiceBusNamespace>,
        Resource.DefinitionWithTags<WithCreate>,
        WithSku,
        WithQueue,
        WithTopic,
        WithAuthorizationRule {
        }

        public static interface WithAuthorizationRule {
            public WithCreate withNewSendRule(String var1);

            public WithCreate withNewListenRule(String var1);

            public WithCreate withNewManageRule(String var1);
        }

        public static interface WithTopic {
            public WithCreate withNewTopic(String var1, int var2);
        }

        public static interface WithQueue {
            public WithCreate withNewQueue(String var1, int var2);
        }

        public static interface WithSku {
            public WithCreate withSku(NamespaceSku var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithCreate> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithCreate {
    }
}

