/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.servicebus.fluent.RegionsClient;
import com.azure.resourcemanager.servicebus.fluent.models.PremiumMessagingRegionInner;
import com.azure.resourcemanager.servicebus.implementation.ServiceBusManagementClientImpl;
import com.azure.resourcemanager.servicebus.models.PremiumMessagingRegionsListResult;
import reactor.core.publisher.Mono;

public final class RegionsClientImpl
implements RegionsClient {
    private final ClientLogger logger = new ClientLogger(RegionsClientImpl.class);
    private final RegionsService service;
    private final ServiceBusManagementClientImpl client;

    RegionsClientImpl(ServiceBusManagementClientImpl client) {
        this.service = (RegionsService)RestProxy.create(RegionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<PremiumMessagingRegionInner>> listBySkuSinglePageAsync(String sku) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (sku == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySku(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), sku, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PremiumMessagingRegionsListResult)res.getValue()).value(), ((PremiumMessagingRegionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<PremiumMessagingRegionInner>> listBySkuSinglePageAsync(String sku, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (sku == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySku(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), sku, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PremiumMessagingRegionsListResult)res.getValue()).value(), ((PremiumMessagingRegionsListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<PremiumMessagingRegionInner> listBySkuAsync(String sku) {
        return new PagedFlux(() -> this.listBySkuSinglePageAsync(sku), nextLink -> this.listBySkuNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<PremiumMessagingRegionInner> listBySkuAsync(String sku, Context context) {
        return new PagedFlux(() -> this.listBySkuSinglePageAsync(sku, context), nextLink -> this.listBySkuNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<PremiumMessagingRegionInner> listBySku(String sku) {
        return new PagedIterable(this.listBySkuAsync(sku));
    }

    @Override
    public PagedIterable<PremiumMessagingRegionInner> listBySku(String sku, Context context) {
        return new PagedIterable(this.listBySkuAsync(sku, context));
    }

    private Mono<PagedResponse<PremiumMessagingRegionInner>> listBySkuNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySkuNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PremiumMessagingRegionsListResult)res.getValue()).value(), ((PremiumMessagingRegionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<PremiumMessagingRegionInner>> listBySkuNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySkuNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PremiumMessagingRegionsListResult)res.getValue()).value(), ((PremiumMessagingRegionsListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ServiceBusManagement")
    private static interface RegionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ServiceBus/sku/{sku}/regions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PremiumMessagingRegionsListResult>> listBySku(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="sku") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PremiumMessagingRegionsListResult>> listBySkuNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

