/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.servicebus.implementation.DurationSerializer;
import com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.azure.resourcemanager.servicebus.models.MessageCountDetails;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;

public final class SBTopicProperties
implements JsonSerializable<SBTopicProperties> {
    private Long sizeInBytes;
    private OffsetDateTime createdAt;
    private OffsetDateTime updatedAt;
    private OffsetDateTime accessedAt;
    private Integer subscriptionCount;
    private MessageCountDetails countDetails;
    private Duration defaultMessageTimeToLive;
    private Integer maxSizeInMegabytes;
    private Long maxMessageSizeInKilobytes;
    private Boolean requiresDuplicateDetection;
    private Duration duplicateDetectionHistoryTimeWindow;
    private Boolean enableBatchedOperations;
    private EntityStatus status;
    private Boolean supportOrdering;
    private Duration autoDeleteOnIdle;
    private Boolean enablePartitioning;
    private Boolean enableExpress;

    public Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public OffsetDateTime accessedAt() {
        return this.accessedAt;
    }

    public Integer subscriptionCount() {
        return this.subscriptionCount;
    }

    public MessageCountDetails countDetails() {
        return this.countDetails;
    }

    public Duration defaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public SBTopicProperties withDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    public Integer maxSizeInMegabytes() {
        return this.maxSizeInMegabytes;
    }

    public SBTopicProperties withMaxSizeInMegabytes(Integer maxSizeInMegabytes) {
        this.maxSizeInMegabytes = maxSizeInMegabytes;
        return this;
    }

    public Long maxMessageSizeInKilobytes() {
        return this.maxMessageSizeInKilobytes;
    }

    public SBTopicProperties withMaxMessageSizeInKilobytes(Long maxMessageSizeInKilobytes) {
        this.maxMessageSizeInKilobytes = maxMessageSizeInKilobytes;
        return this;
    }

    public Boolean requiresDuplicateDetection() {
        return this.requiresDuplicateDetection;
    }

    public SBTopicProperties withRequiresDuplicateDetection(Boolean requiresDuplicateDetection) {
        this.requiresDuplicateDetection = requiresDuplicateDetection;
        return this;
    }

    public Duration duplicateDetectionHistoryTimeWindow() {
        return this.duplicateDetectionHistoryTimeWindow;
    }

    public SBTopicProperties withDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
        this.duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow;
        return this;
    }

    public Boolean enableBatchedOperations() {
        return this.enableBatchedOperations;
    }

    public SBTopicProperties withEnableBatchedOperations(Boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    public EntityStatus status() {
        return this.status;
    }

    public SBTopicProperties withStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public Boolean supportOrdering() {
        return this.supportOrdering;
    }

    public SBTopicProperties withSupportOrdering(Boolean supportOrdering) {
        this.supportOrdering = supportOrdering;
        return this;
    }

    public Duration autoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public SBTopicProperties withAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    public Boolean enablePartitioning() {
        return this.enablePartitioning;
    }

    public SBTopicProperties withEnablePartitioning(Boolean enablePartitioning) {
        this.enablePartitioning = enablePartitioning;
        return this;
    }

    public Boolean enableExpress() {
        return this.enableExpress;
    }

    public SBTopicProperties withEnableExpress(Boolean enableExpress) {
        this.enableExpress = enableExpress;
        return this;
    }

    public void validate() {
        if (this.countDetails() != null) {
            this.countDetails().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("defaultMessageTimeToLive", DurationSerializer.serialize(this.defaultMessageTimeToLive));
        jsonWriter.writeNumberField("maxSizeInMegabytes", (Number)this.maxSizeInMegabytes);
        jsonWriter.writeNumberField("maxMessageSizeInKilobytes", (Number)this.maxMessageSizeInKilobytes);
        jsonWriter.writeBooleanField("requiresDuplicateDetection", this.requiresDuplicateDetection);
        jsonWriter.writeStringField("duplicateDetectionHistoryTimeWindow", DurationSerializer.serialize(this.duplicateDetectionHistoryTimeWindow));
        jsonWriter.writeBooleanField("enableBatchedOperations", this.enableBatchedOperations);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeBooleanField("supportOrdering", this.supportOrdering);
        jsonWriter.writeStringField("autoDeleteOnIdle", DurationSerializer.serialize(this.autoDeleteOnIdle));
        jsonWriter.writeBooleanField("enablePartitioning", this.enablePartitioning);
        jsonWriter.writeBooleanField("enableExpress", this.enableExpress);
        return jsonWriter.writeEndObject();
    }

    public static SBTopicProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SBTopicProperties)jsonReader.readObject(reader -> {
            SBTopicProperties deserializedSBTopicProperties = new SBTopicProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sizeInBytes".equals(fieldName)) {
                    deserializedSBTopicProperties.sizeInBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("createdAt".equals(fieldName)) {
                    deserializedSBTopicProperties.createdAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("updatedAt".equals(fieldName)) {
                    deserializedSBTopicProperties.updatedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("accessedAt".equals(fieldName)) {
                    deserializedSBTopicProperties.accessedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("subscriptionCount".equals(fieldName)) {
                    deserializedSBTopicProperties.subscriptionCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("countDetails".equals(fieldName)) {
                    deserializedSBTopicProperties.countDetails = MessageCountDetails.fromJson(reader);
                    continue;
                }
                if ("defaultMessageTimeToLive".equals(fieldName)) {
                    deserializedSBTopicProperties.defaultMessageTimeToLive = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("maxSizeInMegabytes".equals(fieldName)) {
                    deserializedSBTopicProperties.maxSizeInMegabytes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxMessageSizeInKilobytes".equals(fieldName)) {
                    deserializedSBTopicProperties.maxMessageSizeInKilobytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("requiresDuplicateDetection".equals(fieldName)) {
                    deserializedSBTopicProperties.requiresDuplicateDetection = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("duplicateDetectionHistoryTimeWindow".equals(fieldName)) {
                    deserializedSBTopicProperties.duplicateDetectionHistoryTimeWindow = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("enableBatchedOperations".equals(fieldName)) {
                    deserializedSBTopicProperties.enableBatchedOperations = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSBTopicProperties.status = EntityStatus.fromString(reader.getString());
                    continue;
                }
                if ("supportOrdering".equals(fieldName)) {
                    deserializedSBTopicProperties.supportOrdering = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("autoDeleteOnIdle".equals(fieldName)) {
                    deserializedSBTopicProperties.autoDeleteOnIdle = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("enablePartitioning".equals(fieldName)) {
                    deserializedSBTopicProperties.enablePartitioning = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableExpress".equals(fieldName)) {
                    deserializedSBTopicProperties.enableExpress = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSBTopicProperties;
        });
    }
}

