// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.servicebus.fluent.models.RuleInner;
import java.io.IOException;
import java.util.List;

/**
 * The response of the List rule operation.
 */
@Fluent
public final class RuleListResult implements JsonSerializable<RuleListResult> {
    /*
     * Result of the List Rules operation.
     */
    private List<RuleInner> value;

    /*
     * Link to the next set of results. Not empty if Value contains incomplete list of rules
     */
    private String nextLink;

    /**
     * Creates an instance of RuleListResult class.
     */
    public RuleListResult() {
    }

    /**
     * Get the value property: Result of the List Rules operation.
     * 
     * @return the value value.
     */
    public List<RuleInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Result of the List Rules operation.
     * 
     * @param value the value value to set.
     * @return the RuleListResult object itself.
     */
    public RuleListResult withValue(List<RuleInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of rules.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of rules.
     * 
     * @param nextLink the nextLink value to set.
     * @return the RuleListResult object itself.
     */
    public RuleListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RuleListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RuleListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RuleListResult.
     */
    public static RuleListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RuleListResult deserializedRuleListResult = new RuleListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<RuleInner> value = reader.readArray(reader1 -> RuleInner.fromJson(reader1));
                    deserializedRuleListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedRuleListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRuleListResult;
        });
    }
}
