/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.servicebus.models.OperationDisplay;
import java.io.IOException;

public final class OperationInner
implements JsonSerializable<OperationInner> {
    private String name;
    private Boolean isDataAction;
    private OperationDisplay display;
    private String origin;
    private Object properties;

    public String name() {
        return this.name;
    }

    public Boolean isDataAction() {
        return this.isDataAction;
    }

    public OperationInner withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    public OperationDisplay display() {
        return this.display;
    }

    public OperationInner withDisplay(OperationDisplay display) {
        this.display = display;
        return this;
    }

    public String origin() {
        return this.origin;
    }

    public OperationInner withOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    public Object properties() {
        return this.properties;
    }

    public OperationInner withProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        jsonWriter.writeStringField("origin", this.origin);
        jsonWriter.writeUntypedField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    public static OperationInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationInner)jsonReader.readObject(reader -> {
            OperationInner deserializedOperationInner = new OperationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOperationInner.name = reader.getString();
                    continue;
                }
                if ("isDataAction".equals(fieldName)) {
                    deserializedOperationInner.isDataAction = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedOperationInner.display = OperationDisplay.fromJson(reader);
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedOperationInner.origin = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedOperationInner.properties = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationInner;
        });
    }
}

