// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties required to the Create Migration Configuration.
 */
@Fluent
public final class MigrationConfigPropertiesProperties
    implements JsonSerializable<MigrationConfigPropertiesProperties> {
    /*
     * Provisioning state of Migration Configuration
     */
    private String provisioningState;

    /*
     * Number of entities pending to be replicated.
     */
    private Long pendingReplicationOperationsCount;

    /*
     * Existing premium Namespace ARM Id name which has no entities, will be used for migration
     */
    private String targetNamespace;

    /*
     * Name to access Standard Namespace after migration
     */
    private String postMigrationName;

    /*
     * State in which Standard to Premium Migration is, possible values : Unknown, Reverting, Completing, Initiating,
     * Syncing, Active
     */
    private String migrationState;

    /**
     * Creates an instance of MigrationConfigPropertiesProperties class.
     */
    public MigrationConfigPropertiesProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of Migration Configuration.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the pendingReplicationOperationsCount property: Number of entities pending to be replicated.
     * 
     * @return the pendingReplicationOperationsCount value.
     */
    public Long pendingReplicationOperationsCount() {
        return this.pendingReplicationOperationsCount;
    }

    /**
     * Get the targetNamespace property: Existing premium Namespace ARM Id name which has no entities, will be used for
     * migration.
     * 
     * @return the targetNamespace value.
     */
    public String targetNamespace() {
        return this.targetNamespace;
    }

    /**
     * Set the targetNamespace property: Existing premium Namespace ARM Id name which has no entities, will be used for
     * migration.
     * 
     * @param targetNamespace the targetNamespace value to set.
     * @return the MigrationConfigPropertiesProperties object itself.
     */
    public MigrationConfigPropertiesProperties withTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
        return this;
    }

    /**
     * Get the postMigrationName property: Name to access Standard Namespace after migration.
     * 
     * @return the postMigrationName value.
     */
    public String postMigrationName() {
        return this.postMigrationName;
    }

    /**
     * Set the postMigrationName property: Name to access Standard Namespace after migration.
     * 
     * @param postMigrationName the postMigrationName value to set.
     * @return the MigrationConfigPropertiesProperties object itself.
     */
    public MigrationConfigPropertiesProperties withPostMigrationName(String postMigrationName) {
        this.postMigrationName = postMigrationName;
        return this;
    }

    /**
     * Get the migrationState property: State in which Standard to Premium Migration is, possible values : Unknown,
     * Reverting, Completing, Initiating, Syncing, Active.
     * 
     * @return the migrationState value.
     */
    public String migrationState() {
        return this.migrationState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (targetNamespace() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property targetNamespace in model MigrationConfigPropertiesProperties"));
        }
        if (postMigrationName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property postMigrationName in model MigrationConfigPropertiesProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MigrationConfigPropertiesProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetNamespace", this.targetNamespace);
        jsonWriter.writeStringField("postMigrationName", this.postMigrationName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrationConfigPropertiesProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrationConfigPropertiesProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MigrationConfigPropertiesProperties.
     */
    public static MigrationConfigPropertiesProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrationConfigPropertiesProperties deserializedMigrationConfigPropertiesProperties
                = new MigrationConfigPropertiesProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetNamespace".equals(fieldName)) {
                    deserializedMigrationConfigPropertiesProperties.targetNamespace = reader.getString();
                } else if ("postMigrationName".equals(fieldName)) {
                    deserializedMigrationConfigPropertiesProperties.postMigrationName = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedMigrationConfigPropertiesProperties.provisioningState = reader.getString();
                } else if ("pendingReplicationOperationsCount".equals(fieldName)) {
                    deserializedMigrationConfigPropertiesProperties.pendingReplicationOperationsCount
                        = reader.getNullable(JsonReader::getLong);
                } else if ("migrationState".equals(fieldName)) {
                    deserializedMigrationConfigPropertiesProperties.migrationState = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrationConfigPropertiesProperties;
        });
    }
}
