// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.azure.resourcemanager.servicebus.models.MessageCountDetails;
import com.azure.resourcemanager.servicebus.models.SBClientAffineProperties;

import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;

/**
 * Description of subscription resource.
 */
@Fluent
public final class SBSubscriptionInner extends Resource {
    /*
     * Properties of subscriptions resource.
     */
    private SBSubscriptionProperties innerProperties;

    /*
     * The system meta data relating to this resource.
     */
    private SystemData systemData;

    /*
     * The geo-location where the resource lives
     */
    private String location;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of SBSubscriptionInner class.
     */
    public SBSubscriptionInner() {
    }

    /**
     * Get the innerProperties property: Properties of subscriptions resource.
     * 
     * @return the innerProperties value.
     */
    private SBSubscriptionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system meta data relating to this resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the location property: The geo-location where the resource lives.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the messageCount property: Number of messages.
     * 
     * @return the messageCount value.
     */
    public Long messageCount() {
        return this.innerProperties() == null ? null : this.innerProperties().messageCount();
    }

    /**
     * Get the createdAt property: Exact time the message was created.
     * 
     * @return the createdAt value.
     */
    public OffsetDateTime createdAt() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAt();
    }

    /**
     * Get the accessedAt property: Last time there was a receive request to this subscription.
     * 
     * @return the accessedAt value.
     */
    public OffsetDateTime accessedAt() {
        return this.innerProperties() == null ? null : this.innerProperties().accessedAt();
    }

    /**
     * Get the updatedAt property: The exact time the message was updated.
     * 
     * @return the updatedAt value.
     */
    public OffsetDateTime updatedAt() {
        return this.innerProperties() == null ? null : this.innerProperties().updatedAt();
    }

    /**
     * Get the countDetails property: Message count details.
     * 
     * @return the countDetails value.
     */
    public MessageCountDetails countDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().countDetails();
    }

    /**
     * Get the lockDuration property: ISO 8061 lock duration timespan for the subscription. The default value is 1
     * minute.
     * 
     * @return the lockDuration value.
     */
    public Duration lockDuration() {
        return this.innerProperties() == null ? null : this.innerProperties().lockDuration();
    }

    /**
     * Set the lockDuration property: ISO 8061 lock duration timespan for the subscription. The default value is 1
     * minute.
     * 
     * @param lockDuration the lockDuration value to set.
     * @return the SBSubscriptionInner object itself.
     */
    public SBSubscriptionInner withLockDuration(Duration lockDuration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBSubscriptionProperties();
        }
        this.innerProperties().withLockDuration(lockDuration);
        return this;
    }

    /**
     * Get the requiresSession property: Value indicating if a subscription supports the concept of sessions.
     * 
     * @return the requiresSession value.
     */
    public Boolean requiresSession() {
        return this.innerProperties() == null ? null : this.innerProperties().requiresSession();
    }

    /**
     * Set the requiresSession property: Value indicating if a subscription supports the concept of sessions.
     * 
     * @param requiresSession the requiresSession value to set.
     * @return the SBSubscriptionInner object itself.
     */
    public SBSubscriptionInner withRequiresSession(Boolean requiresSession) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBSubscriptionProperties();
        }
        this.innerProperties().withRequiresSession(requiresSession);
        return this;
    }

    /**
     * Get the defaultMessageTimeToLive property: ISO 8061 Default message timespan to live value. This is the duration
     * after which the message expires, starting from when the message is sent to Service Bus. This is the default value
     * used when TimeToLive is not set on a message itself.
     * 
     * @return the defaultMessageTimeToLive value.
     */
    public Duration defaultMessageTimeToLive() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultMessageTimeToLive();
    }

    /**
     * Set the defaultMessageTimeToLive property: ISO 8061 Default message timespan to live value. This is the duration
     * after which the message expires, starting from when the message is sent to Service Bus. This is the default value
     * used when TimeToLive is not set on a message itself.
     * 
     * @param defaultMessageTimeToLive the defaultMessageTimeToLive value to set.
     * @return the SBSubscriptionInner object itself.
     */
    public SBSubscriptionInner withDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBSubscriptionProperties();
        }
        this.innerProperties().withDefaultMessageTimeToLive(defaultMessageTimeToLive);
        return this;
    }

    /**
     * Get the deadLetteringOnFilterEvaluationExceptions property: Value that indicates whether a subscription has dead
     * letter support on filter evaluation exceptions.
     * 
     * @return the deadLetteringOnFilterEvaluationExceptions value.
     */
    public Boolean deadLetteringOnFilterEvaluationExceptions() {
        return this.innerProperties() == null
            ? null
            : this.innerProperties().deadLetteringOnFilterEvaluationExceptions();
    }

    /**
     * Set the deadLetteringOnFilterEvaluationExceptions property: Value that indicates whether a subscription has dead
     * letter support on filter evaluation exceptions.
     * 
     * @param deadLetteringOnFilterEvaluationExceptions the deadLetteringOnFilterEvaluationExceptions value to set.
     * @return the SBSubscriptionInner object itself.
     */
    public SBSubscriptionInner
        withDeadLetteringOnFilterEvaluationExceptions(Boolean deadLetteringOnFilterEvaluationExceptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBSubscriptionProperties();
        }
        this.innerProperties().withDeadLetteringOnFilterEvaluationExceptions(deadLetteringOnFilterEvaluationExceptions);
        return this;
    }

    /**
     * Get the deadLetteringOnMessageExpiration property: Value that indicates whether a subscription has dead letter
     * support when a message expires.
     * 
     * @return the deadLetteringOnMessageExpiration value.
     */
    public Boolean deadLetteringOnMessageExpiration() {
        return this.innerProperties() == null ? null : this.innerProperties().deadLetteringOnMessageExpiration();
    }

    /**
     * Set the deadLetteringOnMessageExpiration property: Value that indicates whether a subscription has dead letter
     * support when a message expires.
     * 
     * @param deadLetteringOnMessageExpiration the deadLetteringOnMessageExpiration value to set.
     * @return the SBSubscriptionInner object itself.
     */
    public SBSubscriptionInner withDeadLetteringOnMessageExpiration(Boolean deadLetteringOnMessageExpiration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBSubscriptionProperties();
        }
        this.innerProperties().withDeadLetteringOnMessageExpiration(deadLetteringOnMessageExpiration);
        return this;
    }

    /**
     * Get the duplicateDetectionHistoryTimeWindow property: ISO 8601 timeSpan structure that defines the duration of
     * the duplicate detection history. The default value is 10 minutes.
     * 
     * @return the duplicateDetectionHistoryTimeWindow value.
     */
    public Duration duplicateDetectionHistoryTimeWindow() {
        return this.innerProperties() == null ? null : this.innerProperties().duplicateDetectionHistoryTimeWindow();
    }

    /**
     * Set the duplicateDetectionHistoryTimeWindow property: ISO 8601 timeSpan structure that defines the duration of
     * the duplicate detection history. The default value is 10 minutes.
     * 
     * @param duplicateDetectionHistoryTimeWindow the duplicateDetectionHistoryTimeWindow value to set.
     * @return the SBSubscriptionInner object itself.
     */
    public SBSubscriptionInner withDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBSubscriptionProperties();
        }
        this.innerProperties().withDuplicateDetectionHistoryTimeWindow(duplicateDetectionHistoryTimeWindow);
        return this;
    }

    /**
     * Get the maxDeliveryCount property: Number of maximum deliveries.
     * 
     * @return the maxDeliveryCount value.
     */
    public Integer maxDeliveryCount() {
        return this.innerProperties() == null ? null : this.innerProperties().maxDeliveryCount();
    }

    /**
     * Set the maxDeliveryCount property: Number of maximum deliveries.
     * 
     * @param maxDeliveryCount the maxDeliveryCount value to set.
     * @return the SBSubscriptionInner object itself.
     */
    public SBSubscriptionInner withMaxDeliveryCount(Integer maxDeliveryCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBSubscriptionProperties();
        }
        this.innerProperties().withMaxDeliveryCount(maxDeliveryCount);
        return this;
    }

    /**
     * Get the status property: Enumerates the possible values for the status of a messaging entity.
     * 
     * @return the status value.
     */
    public EntityStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Set the status property: Enumerates the possible values for the status of a messaging entity.
     * 
     * @param status the status value to set.
     * @return the SBSubscriptionInner object itself.
     */
    public SBSubscriptionInner withStatus(EntityStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBSubscriptionProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    /**
     * Get the enableBatchedOperations property: Value that indicates whether server-side batched operations are
     * enabled.
     * 
     * @return the enableBatchedOperations value.
     */
    public Boolean enableBatchedOperations() {
        return this.innerProperties() == null ? null : this.innerProperties().enableBatchedOperations();
    }

    /**
     * Set the enableBatchedOperations property: Value that indicates whether server-side batched operations are
     * enabled.
     * 
     * @param enableBatchedOperations the enableBatchedOperations value to set.
     * @return the SBSubscriptionInner object itself.
     */
    public SBSubscriptionInner withEnableBatchedOperations(Boolean enableBatchedOperations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBSubscriptionProperties();
        }
        this.innerProperties().withEnableBatchedOperations(enableBatchedOperations);
        return this;
    }

    /**
     * Get the autoDeleteOnIdle property: ISO 8061 timeSpan idle interval after which the topic is automatically
     * deleted. The minimum duration is 5 minutes.
     * 
     * @return the autoDeleteOnIdle value.
     */
    public Duration autoDeleteOnIdle() {
        return this.innerProperties() == null ? null : this.innerProperties().autoDeleteOnIdle();
    }

    /**
     * Set the autoDeleteOnIdle property: ISO 8061 timeSpan idle interval after which the topic is automatically
     * deleted. The minimum duration is 5 minutes.
     * 
     * @param autoDeleteOnIdle the autoDeleteOnIdle value to set.
     * @return the SBSubscriptionInner object itself.
     */
    public SBSubscriptionInner withAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBSubscriptionProperties();
        }
        this.innerProperties().withAutoDeleteOnIdle(autoDeleteOnIdle);
        return this;
    }

    /**
     * Get the forwardTo property: Queue/Topic name to forward the messages.
     * 
     * @return the forwardTo value.
     */
    public String forwardTo() {
        return this.innerProperties() == null ? null : this.innerProperties().forwardTo();
    }

    /**
     * Set the forwardTo property: Queue/Topic name to forward the messages.
     * 
     * @param forwardTo the forwardTo value to set.
     * @return the SBSubscriptionInner object itself.
     */
    public SBSubscriptionInner withForwardTo(String forwardTo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBSubscriptionProperties();
        }
        this.innerProperties().withForwardTo(forwardTo);
        return this;
    }

    /**
     * Get the forwardDeadLetteredMessagesTo property: Queue/Topic name to forward the Dead Letter message.
     * 
     * @return the forwardDeadLetteredMessagesTo value.
     */
    public String forwardDeadLetteredMessagesTo() {
        return this.innerProperties() == null ? null : this.innerProperties().forwardDeadLetteredMessagesTo();
    }

    /**
     * Set the forwardDeadLetteredMessagesTo property: Queue/Topic name to forward the Dead Letter message.
     * 
     * @param forwardDeadLetteredMessagesTo the forwardDeadLetteredMessagesTo value to set.
     * @return the SBSubscriptionInner object itself.
     */
    public SBSubscriptionInner withForwardDeadLetteredMessagesTo(String forwardDeadLetteredMessagesTo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBSubscriptionProperties();
        }
        this.innerProperties().withForwardDeadLetteredMessagesTo(forwardDeadLetteredMessagesTo);
        return this;
    }

    /**
     * Get the isClientAffine property: Value that indicates whether the subscription has an affinity to the client id.
     * 
     * @return the isClientAffine value.
     */
    public Boolean isClientAffine() {
        return this.innerProperties() == null ? null : this.innerProperties().isClientAffine();
    }

    /**
     * Set the isClientAffine property: Value that indicates whether the subscription has an affinity to the client id.
     * 
     * @param isClientAffine the isClientAffine value to set.
     * @return the SBSubscriptionInner object itself.
     */
    public SBSubscriptionInner withIsClientAffine(Boolean isClientAffine) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBSubscriptionProperties();
        }
        this.innerProperties().withIsClientAffine(isClientAffine);
        return this;
    }

    /**
     * Get the clientAffineProperties property: Properties specific to client affine subscriptions.
     * 
     * @return the clientAffineProperties value.
     */
    public SBClientAffineProperties clientAffineProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().clientAffineProperties();
    }

    /**
     * Set the clientAffineProperties property: Properties specific to client affine subscriptions.
     * 
     * @param clientAffineProperties the clientAffineProperties value to set.
     * @return the SBSubscriptionInner object itself.
     */
    public SBSubscriptionInner withClientAffineProperties(SBClientAffineProperties clientAffineProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBSubscriptionProperties();
        }
        this.innerProperties().withClientAffineProperties(clientAffineProperties);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SBSubscriptionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SBSubscriptionInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SBSubscriptionInner.
     */
    public static SBSubscriptionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SBSubscriptionInner deserializedSBSubscriptionInner = new SBSubscriptionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSBSubscriptionInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSBSubscriptionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSBSubscriptionInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedSBSubscriptionInner.innerProperties = SBSubscriptionProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedSBSubscriptionInner.systemData = SystemData.fromJson(reader);
                } else if ("location".equals(fieldName)) {
                    deserializedSBSubscriptionInner.location = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSBSubscriptionInner;
        });
    }
}
