// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.servicebus.fluent.models.MigrationConfigPropertiesInner;
import java.io.IOException;
import java.util.List;

/**
 * The result of the List migrationConfigurations operation.
 */
@Fluent
public final class MigrationConfigListResult implements JsonSerializable<MigrationConfigListResult> {
    /*
     * List of Migration Configs
     */
    private List<MigrationConfigPropertiesInner> value;

    /*
     * Link to the next set of results. Not empty if Value contains incomplete list of migrationConfigurations
     */
    private String nextLink;

    /**
     * Creates an instance of MigrationConfigListResult class.
     */
    public MigrationConfigListResult() {
    }

    /**
     * Get the value property: List of Migration Configs.
     * 
     * @return the value value.
     */
    public List<MigrationConfigPropertiesInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of Migration Configs.
     * 
     * @param value the value value to set.
     * @return the MigrationConfigListResult object itself.
     */
    public MigrationConfigListResult withValue(List<MigrationConfigPropertiesInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of
     * migrationConfigurations.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrationConfigListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrationConfigListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MigrationConfigListResult.
     */
    public static MigrationConfigListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrationConfigListResult deserializedMigrationConfigListResult = new MigrationConfigListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<MigrationConfigPropertiesInner> value
                        = reader.readArray(reader1 -> MigrationConfigPropertiesInner.fromJson(reader1));
                    deserializedMigrationConfigListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedMigrationConfigListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrationConfigListResult;
        });
    }
}
