// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.servicebus.fluent.models.SBTopicInner;
import java.io.IOException;
import java.util.List;

/**
 * The response to the List Topics operation.
 */
@Fluent
public final class SBTopicListResult implements JsonSerializable<SBTopicListResult> {
    /*
     * Result of the List Topics operation.
     */
    private List<SBTopicInner> value;

    /*
     * Link to the next set of results. Not empty if Value contains incomplete list of topics.
     */
    private String nextLink;

    /**
     * Creates an instance of SBTopicListResult class.
     */
    public SBTopicListResult() {
    }

    /**
     * Get the value property: Result of the List Topics operation.
     * 
     * @return the value value.
     */
    public List<SBTopicInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Result of the List Topics operation.
     * 
     * @param value the value value to set.
     * @return the SBTopicListResult object itself.
     */
    public SBTopicListResult withValue(List<SBTopicInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of
     * topics.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of
     * topics.
     * 
     * @param nextLink the nextLink value to set.
     * @return the SBTopicListResult object itself.
     */
    public SBTopicListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SBTopicListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SBTopicListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SBTopicListResult.
     */
    public static SBTopicListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SBTopicListResult deserializedSBTopicListResult = new SBTopicListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SBTopicInner> value = reader.readArray(reader1 -> SBTopicInner.fromJson(reader1));
                    deserializedSBTopicListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedSBTopicListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSBTopicListResult;
        });
    }
}
