/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.servicebus.models.Action;
import java.io.IOException;

public final class SqlRuleAction
extends Action {
    @Override
    public SqlRuleAction withSqlExpression(String sqlExpression) {
        super.withSqlExpression(sqlExpression);
        return this;
    }

    @Override
    public SqlRuleAction withCompatibilityLevel(Integer compatibilityLevel) {
        super.withCompatibilityLevel(compatibilityLevel);
        return this;
    }

    @Override
    public SqlRuleAction withRequiresPreprocessing(Boolean requiresPreprocessing) {
        super.withRequiresPreprocessing(requiresPreprocessing);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sqlExpression", this.sqlExpression());
        jsonWriter.writeNumberField("compatibilityLevel", (Number)this.compatibilityLevel());
        jsonWriter.writeBooleanField("requiresPreprocessing", this.requiresPreprocessing());
        return jsonWriter.writeEndObject();
    }

    public static SqlRuleAction fromJson(JsonReader jsonReader) throws IOException {
        return (SqlRuleAction)jsonReader.readObject(reader -> {
            SqlRuleAction deserializedSqlRuleAction = new SqlRuleAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sqlExpression".equals(fieldName)) {
                    deserializedSqlRuleAction.withSqlExpression(reader.getString());
                    continue;
                }
                if ("compatibilityLevel".equals(fieldName)) {
                    deserializedSqlRuleAction.withCompatibilityLevel((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("requiresPreprocessing".equals(fieldName)) {
                    deserializedSqlRuleAction.withRequiresPreprocessing((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlRuleAction;
        });
    }
}

