// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Description of a Check Name availability request properties. */
@Fluent
public final class CheckNameAvailability {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(CheckNameAvailability.class);

    /*
     * The Name to check the namespace name availability and The namespace name
     * can contain only letters, numbers, and hyphens. The namespace must start
     * with a letter, and it must end with a letter or number.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * Get the name property: The Name to check the namespace name availability and The namespace name can contain only
     * letters, numbers, and hyphens. The namespace must start with a letter, and it must end with a letter or number.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The Name to check the namespace name availability and The namespace name can contain only
     * letters, numbers, and hyphens. The namespace must start with a letter, and it must end with a letter or number.
     *
     * @param name the name value to set.
     * @return the CheckNameAvailability object itself.
     */
    public CheckNameAvailability withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property name in model CheckNameAvailability"));
        }
    }
}
