// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.servicebus.fluent.models.SBQueueInner;
import java.io.IOException;
import java.util.List;

/**
 * The response to the List Queues operation.
 */
@Fluent
public final class SBQueueListResult implements JsonSerializable<SBQueueListResult> {
    /*
     * Result of the List Queues operation.
     */
    private List<SBQueueInner> value;

    /*
     * Link to the next set of results. Not empty if Value contains incomplete list of queues.
     */
    private String nextLink;

    /**
     * Creates an instance of SBQueueListResult class.
     */
    public SBQueueListResult() {
    }

    /**
     * Get the value property: Result of the List Queues operation.
     * 
     * @return the value value.
     */
    public List<SBQueueInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Result of the List Queues operation.
     * 
     * @param value the value value to set.
     * @return the SBQueueListResult object itself.
     */
    public SBQueueListResult withValue(List<SBQueueInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of
     * queues.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of
     * queues.
     * 
     * @param nextLink the nextLink value to set.
     * @return the SBQueueListResult object itself.
     */
    public SBQueueListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SBQueueListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SBQueueListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SBQueueListResult.
     */
    public static SBQueueListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SBQueueListResult deserializedSBQueueListResult = new SBQueueListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SBQueueInner> value = reader.readArray(reader1 -> SBQueueInner.fromJson(reader1));
                    deserializedSBQueueListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedSBQueueListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSBQueueListResult;
        });
    }
}
