// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicelinker.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.servicelinker.models.AuthInfoBase;
import com.azure.resourcemanager.servicelinker.models.ClientType;
import com.azure.resourcemanager.servicelinker.models.SecretStore;
import com.azure.resourcemanager.servicelinker.models.TargetServiceBase;
import com.azure.resourcemanager.servicelinker.models.VNetSolution;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The properties of the linker. */
@Fluent
public final class LinkerProperties {
    /*
     * The target service properties
     */
    @JsonProperty(value = "targetService")
    private TargetServiceBase targetService;

    /*
     * The authentication type.
     */
    @JsonProperty(value = "authInfo")
    private AuthInfoBase authInfo;

    /*
     * The application client type
     */
    @JsonProperty(value = "clientType")
    private ClientType clientType;

    /*
     * The provisioning state.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    /*
     * The VNet solution.
     */
    @JsonProperty(value = "vNetSolution")
    private VNetSolution vNetSolution;

    /*
     * An option to store secret value in secure place
     */
    @JsonProperty(value = "secretStore")
    private SecretStore secretStore;

    /*
     * connection scope in source service.
     */
    @JsonProperty(value = "scope")
    private String scope;

    /**
     * Get the targetService property: The target service properties.
     *
     * @return the targetService value.
     */
    public TargetServiceBase targetService() {
        return this.targetService;
    }

    /**
     * Set the targetService property: The target service properties.
     *
     * @param targetService the targetService value to set.
     * @return the LinkerProperties object itself.
     */
    public LinkerProperties withTargetService(TargetServiceBase targetService) {
        this.targetService = targetService;
        return this;
    }

    /**
     * Get the authInfo property: The authentication type.
     *
     * @return the authInfo value.
     */
    public AuthInfoBase authInfo() {
        return this.authInfo;
    }

    /**
     * Set the authInfo property: The authentication type.
     *
     * @param authInfo the authInfo value to set.
     * @return the LinkerProperties object itself.
     */
    public LinkerProperties withAuthInfo(AuthInfoBase authInfo) {
        this.authInfo = authInfo;
        return this;
    }

    /**
     * Get the clientType property: The application client type.
     *
     * @return the clientType value.
     */
    public ClientType clientType() {
        return this.clientType;
    }

    /**
     * Set the clientType property: The application client type.
     *
     * @param clientType the clientType value to set.
     * @return the LinkerProperties object itself.
     */
    public LinkerProperties withClientType(ClientType clientType) {
        this.clientType = clientType;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state.
     *
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the vNetSolution property: The VNet solution.
     *
     * @return the vNetSolution value.
     */
    public VNetSolution vNetSolution() {
        return this.vNetSolution;
    }

    /**
     * Set the vNetSolution property: The VNet solution.
     *
     * @param vNetSolution the vNetSolution value to set.
     * @return the LinkerProperties object itself.
     */
    public LinkerProperties withVNetSolution(VNetSolution vNetSolution) {
        this.vNetSolution = vNetSolution;
        return this;
    }

    /**
     * Get the secretStore property: An option to store secret value in secure place.
     *
     * @return the secretStore value.
     */
    public SecretStore secretStore() {
        return this.secretStore;
    }

    /**
     * Set the secretStore property: An option to store secret value in secure place.
     *
     * @param secretStore the secretStore value to set.
     * @return the LinkerProperties object itself.
     */
    public LinkerProperties withSecretStore(SecretStore secretStore) {
        this.secretStore = secretStore;
        return this;
    }

    /**
     * Get the scope property: connection scope in source service.
     *
     * @return the scope value.
     */
    public String scope() {
        return this.scope;
    }

    /**
     * Set the scope property: connection scope in source service.
     *
     * @param scope the scope value to set.
     * @return the LinkerProperties object itself.
     */
    public LinkerProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (targetService() != null) {
            targetService().validate();
        }
        if (authInfo() != null) {
            authInfo().validate();
        }
        if (vNetSolution() != null) {
            vNetSolution().validate();
        }
        if (secretStore() != null) {
            secretStore().validate();
        }
    }
}
