// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicelinker.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.servicelinker.models.AuthType;
import com.azure.resourcemanager.servicelinker.models.ValidationResultItem;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** The validation result for a linker. */
@Fluent
public final class ValidateResult {
    /*
     * The linker name.
     */
    @JsonProperty(value = "linkerName")
    private String linkerName;

    /*
     * A boolean value indicating whether the connection is available or not
     */
    @JsonProperty(value = "isConnectionAvailable")
    private Boolean isConnectionAvailable;

    /*
     * The start time of the validation report.
     */
    @JsonProperty(value = "reportStartTimeUtc")
    private OffsetDateTime reportStartTimeUtc;

    /*
     * The end time of the validation report.
     */
    @JsonProperty(value = "reportEndTimeUtc")
    private OffsetDateTime reportEndTimeUtc;

    /*
     * The resource id of the linker source application.
     */
    @JsonProperty(value = "sourceId")
    private String sourceId;

    /*
     * The resource Id of target service.
     */
    @JsonProperty(value = "targetId")
    private String targetId;

    /*
     * The authentication type.
     */
    @JsonProperty(value = "authType")
    private AuthType authType;

    /*
     * The detail of validation result
     */
    @JsonProperty(value = "validationDetail")
    private List<ValidationResultItem> validationDetail;

    /**
     * Get the linkerName property: The linker name.
     *
     * @return the linkerName value.
     */
    public String linkerName() {
        return this.linkerName;
    }

    /**
     * Set the linkerName property: The linker name.
     *
     * @param linkerName the linkerName value to set.
     * @return the ValidateResult object itself.
     */
    public ValidateResult withLinkerName(String linkerName) {
        this.linkerName = linkerName;
        return this;
    }

    /**
     * Get the isConnectionAvailable property: A boolean value indicating whether the connection is available or not.
     *
     * @return the isConnectionAvailable value.
     */
    public Boolean isConnectionAvailable() {
        return this.isConnectionAvailable;
    }

    /**
     * Set the isConnectionAvailable property: A boolean value indicating whether the connection is available or not.
     *
     * @param isConnectionAvailable the isConnectionAvailable value to set.
     * @return the ValidateResult object itself.
     */
    public ValidateResult withIsConnectionAvailable(Boolean isConnectionAvailable) {
        this.isConnectionAvailable = isConnectionAvailable;
        return this;
    }

    /**
     * Get the reportStartTimeUtc property: The start time of the validation report.
     *
     * @return the reportStartTimeUtc value.
     */
    public OffsetDateTime reportStartTimeUtc() {
        return this.reportStartTimeUtc;
    }

    /**
     * Set the reportStartTimeUtc property: The start time of the validation report.
     *
     * @param reportStartTimeUtc the reportStartTimeUtc value to set.
     * @return the ValidateResult object itself.
     */
    public ValidateResult withReportStartTimeUtc(OffsetDateTime reportStartTimeUtc) {
        this.reportStartTimeUtc = reportStartTimeUtc;
        return this;
    }

    /**
     * Get the reportEndTimeUtc property: The end time of the validation report.
     *
     * @return the reportEndTimeUtc value.
     */
    public OffsetDateTime reportEndTimeUtc() {
        return this.reportEndTimeUtc;
    }

    /**
     * Set the reportEndTimeUtc property: The end time of the validation report.
     *
     * @param reportEndTimeUtc the reportEndTimeUtc value to set.
     * @return the ValidateResult object itself.
     */
    public ValidateResult withReportEndTimeUtc(OffsetDateTime reportEndTimeUtc) {
        this.reportEndTimeUtc = reportEndTimeUtc;
        return this;
    }

    /**
     * Get the sourceId property: The resource id of the linker source application.
     *
     * @return the sourceId value.
     */
    public String sourceId() {
        return this.sourceId;
    }

    /**
     * Set the sourceId property: The resource id of the linker source application.
     *
     * @param sourceId the sourceId value to set.
     * @return the ValidateResult object itself.
     */
    public ValidateResult withSourceId(String sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    /**
     * Get the targetId property: The resource Id of target service.
     *
     * @return the targetId value.
     */
    public String targetId() {
        return this.targetId;
    }

    /**
     * Set the targetId property: The resource Id of target service.
     *
     * @param targetId the targetId value to set.
     * @return the ValidateResult object itself.
     */
    public ValidateResult withTargetId(String targetId) {
        this.targetId = targetId;
        return this;
    }

    /**
     * Get the authType property: The authentication type.
     *
     * @return the authType value.
     */
    public AuthType authType() {
        return this.authType;
    }

    /**
     * Set the authType property: The authentication type.
     *
     * @param authType the authType value to set.
     * @return the ValidateResult object itself.
     */
    public ValidateResult withAuthType(AuthType authType) {
        this.authType = authType;
        return this;
    }

    /**
     * Get the validationDetail property: The detail of validation result.
     *
     * @return the validationDetail value.
     */
    public List<ValidationResultItem> validationDetail() {
        return this.validationDetail;
    }

    /**
     * Set the validationDetail property: The detail of validation result.
     *
     * @param validationDetail the validationDetail value to set.
     * @return the ValidateResult object itself.
     */
    public ValidateResult withValidationDetail(List<ValidationResultItem> validationDetail) {
        this.validationDetail = validationDetail;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (validationDetail() != null) {
            validationDetail().forEach(e -> e.validate());
        }
    }
}
