// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicelinker.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.servicelinker.fluent.models.LinkerResourceInner;
import com.azure.resourcemanager.servicelinker.models.AuthInfoBase;
import com.azure.resourcemanager.servicelinker.models.ClientType;
import com.azure.resourcemanager.servicelinker.models.LinkerPatch;
import com.azure.resourcemanager.servicelinker.models.LinkerResource;
import com.azure.resourcemanager.servicelinker.models.SecretStore;
import com.azure.resourcemanager.servicelinker.models.SourceConfigurationResult;
import com.azure.resourcemanager.servicelinker.models.TargetServiceBase;
import com.azure.resourcemanager.servicelinker.models.VNetSolution;
import com.azure.resourcemanager.servicelinker.models.ValidateOperationResult;

public final class LinkerResourceImpl implements LinkerResource, LinkerResource.Definition, LinkerResource.Update {
    private LinkerResourceInner innerObject;

    private final com.azure.resourcemanager.servicelinker.ServiceLinkerManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public TargetServiceBase targetService() {
        return this.innerModel().targetService();
    }

    public AuthInfoBase authInfo() {
        return this.innerModel().authInfo();
    }

    public ClientType clientType() {
        return this.innerModel().clientType();
    }

    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    public VNetSolution vNetSolution() {
        return this.innerModel().vNetSolution();
    }

    public SecretStore secretStore() {
        return this.innerModel().secretStore();
    }

    public String scope() {
        return this.innerModel().scope();
    }

    public LinkerResourceInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.servicelinker.ServiceLinkerManager manager() {
        return this.serviceManager;
    }

    private String resourceUri;

    private String linkerName;

    private LinkerPatch updateParameters;

    public LinkerResourceImpl withExistingResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
        return this;
    }

    public LinkerResource create() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getLinkers()
                .createOrUpdate(resourceUri, linkerName, this.innerModel(), Context.NONE);
        return this;
    }

    public LinkerResource create(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getLinkers()
                .createOrUpdate(resourceUri, linkerName, this.innerModel(), context);
        return this;
    }

    LinkerResourceImpl(String name, com.azure.resourcemanager.servicelinker.ServiceLinkerManager serviceManager) {
        this.innerObject = new LinkerResourceInner();
        this.serviceManager = serviceManager;
        this.linkerName = name;
    }

    public LinkerResourceImpl update() {
        this.updateParameters = new LinkerPatch();
        return this;
    }

    public LinkerResource apply() {
        this.innerObject =
            serviceManager.serviceClient().getLinkers().update(resourceUri, linkerName, updateParameters, Context.NONE);
        return this;
    }

    public LinkerResource apply(Context context) {
        this.innerObject =
            serviceManager.serviceClient().getLinkers().update(resourceUri, linkerName, updateParameters, context);
        return this;
    }

    LinkerResourceImpl(
        LinkerResourceInner innerObject, com.azure.resourcemanager.servicelinker.ServiceLinkerManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceUri =
            Utils
                .getValueFromIdByParameterName(
                    innerObject.id(),
                    "/{resourceUri}/providers/Microsoft.ServiceLinker/linkers/{linkerName}",
                    "resourceUri");
        this.linkerName =
            Utils
                .getValueFromIdByParameterName(
                    innerObject.id(),
                    "/{resourceUri}/providers/Microsoft.ServiceLinker/linkers/{linkerName}",
                    "linkerName");
    }

    public LinkerResource refresh() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getLinkers()
                .getWithResponse(resourceUri, linkerName, Context.NONE)
                .getValue();
        return this;
    }

    public LinkerResource refresh(Context context) {
        this.innerObject =
            serviceManager.serviceClient().getLinkers().getWithResponse(resourceUri, linkerName, context).getValue();
        return this;
    }

    public ValidateOperationResult validate() {
        return serviceManager.linkers().validate(resourceUri, linkerName);
    }

    public ValidateOperationResult validate(Context context) {
        return serviceManager.linkers().validate(resourceUri, linkerName, context);
    }

    public SourceConfigurationResult listConfigurations() {
        return serviceManager.linkers().listConfigurations(resourceUri, linkerName);
    }

    public Response<SourceConfigurationResult> listConfigurationsWithResponse(Context context) {
        return serviceManager.linkers().listConfigurationsWithResponse(resourceUri, linkerName, context);
    }

    public LinkerResourceImpl withTargetService(TargetServiceBase targetService) {
        if (isInCreateMode()) {
            this.innerModel().withTargetService(targetService);
            return this;
        } else {
            this.updateParameters.withTargetService(targetService);
            return this;
        }
    }

    public LinkerResourceImpl withAuthInfo(AuthInfoBase authInfo) {
        if (isInCreateMode()) {
            this.innerModel().withAuthInfo(authInfo);
            return this;
        } else {
            this.updateParameters.withAuthInfo(authInfo);
            return this;
        }
    }

    public LinkerResourceImpl withClientType(ClientType clientType) {
        if (isInCreateMode()) {
            this.innerModel().withClientType(clientType);
            return this;
        } else {
            this.updateParameters.withClientType(clientType);
            return this;
        }
    }

    public LinkerResourceImpl withVNetSolution(VNetSolution vNetSolution) {
        if (isInCreateMode()) {
            this.innerModel().withVNetSolution(vNetSolution);
            return this;
        } else {
            this.updateParameters.withVNetSolution(vNetSolution);
            return this;
        }
    }

    public LinkerResourceImpl withSecretStore(SecretStore secretStore) {
        if (isInCreateMode()) {
            this.innerModel().withSecretStore(secretStore);
            return this;
        } else {
            this.updateParameters.withSecretStore(secretStore);
            return this;
        }
    }

    public LinkerResourceImpl withScope(String scope) {
        if (isInCreateMode()) {
            this.innerModel().withScope(scope);
            return this;
        } else {
            this.updateParameters.withScope(scope);
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
