// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicelinker.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** The resource properties when type is Azure Key Vault. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("KeyVault")
@Fluent
public final class AzureKeyVaultProperties extends AzureResourcePropertiesBase {
    /*
     * True if connect via Kubernetes CSI Driver.
     */
    @JsonProperty(value = "connectAsKubernetesCsiDriver")
    private Boolean connectAsKubernetesCsiDriver;

    /**
     * Get the connectAsKubernetesCsiDriver property: True if connect via Kubernetes CSI Driver.
     *
     * @return the connectAsKubernetesCsiDriver value.
     */
    public Boolean connectAsKubernetesCsiDriver() {
        return this.connectAsKubernetesCsiDriver;
    }

    /**
     * Set the connectAsKubernetesCsiDriver property: True if connect via Kubernetes CSI Driver.
     *
     * @param connectAsKubernetesCsiDriver the connectAsKubernetesCsiDriver value to set.
     * @return the AzureKeyVaultProperties object itself.
     */
    public AzureKeyVaultProperties withConnectAsKubernetesCsiDriver(Boolean connectAsKubernetesCsiDriver) {
        this.connectAsKubernetesCsiDriver = connectAsKubernetesCsiDriver;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
