// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicelinker.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for AzureResourceType. */
public final class AzureResourceType extends ExpandableStringEnum<AzureResourceType> {
    /** Static value KeyVault for AzureResourceType. */
    public static final AzureResourceType KEY_VAULT = fromString("KeyVault");

    /**
     * Creates or finds a AzureResourceType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AzureResourceType.
     */
    @JsonCreator
    public static AzureResourceType fromString(String name) {
        return fromString(name, AzureResourceType.class);
    }

    /**
     * Gets known AzureResourceType values.
     *
     * @return known AzureResourceType values.
     */
    public static Collection<AzureResourceType> values() {
        return values(AzureResourceType.class);
    }
}
