// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicelinker.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The secret info when type is keyVaultSecretReference. It's for scenario that user provides a secret stored in user's
 * keyvault and source is Azure Kubernetes. The key Vault's resource id is linked to secretStore.keyVaultId.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "secretType")
@JsonTypeName("keyVaultSecretReference")
@Fluent
public final class KeyVaultSecretReferenceSecretInfo extends SecretInfoBase {
    /*
     * Name of the Key Vault secret.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Version of the Key Vault secret.
     */
    @JsonProperty(value = "version")
    private String version;

    /**
     * Get the name property: Name of the Key Vault secret.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the Key Vault secret.
     *
     * @param name the name value to set.
     * @return the KeyVaultSecretReferenceSecretInfo object itself.
     */
    public KeyVaultSecretReferenceSecretInfo withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the version property: Version of the Key Vault secret.
     *
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: Version of the Key Vault secret.
     *
     * @param version the version value to set.
     * @return the KeyVaultSecretReferenceSecretInfo object itself.
     */
    public KeyVaultSecretReferenceSecretInfo withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
