// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicelinker.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.servicelinker.fluent.models.LinkerResourceInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The list of Linker. */
@Fluent
public final class LinkerList {
    /*
     * The link used to get the next page of Linker list.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /*
     * The list of Linkers.
     */
    @JsonProperty(value = "value")
    private List<LinkerResourceInner> value;

    /**
     * Get the nextLink property: The link used to get the next page of Linker list.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link used to get the next page of Linker list.
     *
     * @param nextLink the nextLink value to set.
     * @return the LinkerList object itself.
     */
    public LinkerList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Get the value property: The list of Linkers.
     *
     * @return the value value.
     */
    public List<LinkerResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of Linkers.
     *
     * @param value the value value to set.
     * @return the LinkerList object itself.
     */
    public LinkerList withValue(List<LinkerResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
