// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicelinker.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** The authentication info when authType is secret. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "authType")
@JsonTypeName("secret")
@Fluent
public final class SecretAuthInfo extends AuthInfoBase {
    /*
     * Username or account name for secret auth.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Password or key vault secret for secret auth.
     */
    @JsonProperty(value = "secretInfo")
    private SecretInfoBase secretInfo;

    /**
     * Get the name property: Username or account name for secret auth.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Username or account name for secret auth.
     *
     * @param name the name value to set.
     * @return the SecretAuthInfo object itself.
     */
    public SecretAuthInfo withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the secretInfo property: Password or key vault secret for secret auth.
     *
     * @return the secretInfo value.
     */
    public SecretInfoBase secretInfo() {
        return this.secretInfo;
    }

    /**
     * Set the secretInfo property: Password or key vault secret for secret auth.
     *
     * @param secretInfo the secretInfo value to set.
     * @return the SecretAuthInfo object itself.
     */
    public SecretAuthInfo withSecretInfo(SecretInfoBase secretInfo) {
        this.secretInfo = secretInfo;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (secretInfo() != null) {
            secretInfo().validate();
        }
    }
}
