// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicelinker.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** The authentication info when authType is servicePrincipal certificate. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "authType")
@JsonTypeName("servicePrincipalCertificate")
@Fluent
public final class ServicePrincipalCertificateAuthInfo extends AuthInfoBase {
    /*
     * Application clientId for servicePrincipal auth.
     */
    @JsonProperty(value = "clientId", required = true)
    private String clientId;

    /*
     * Principal Id for servicePrincipal auth.
     */
    @JsonProperty(value = "principalId", required = true)
    private String principalId;

    /*
     * ServicePrincipal certificate for servicePrincipal auth.
     */
    @JsonProperty(value = "certificate", required = true)
    private String certificate;

    /**
     * Get the clientId property: Application clientId for servicePrincipal auth.
     *
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: Application clientId for servicePrincipal auth.
     *
     * @param clientId the clientId value to set.
     * @return the ServicePrincipalCertificateAuthInfo object itself.
     */
    public ServicePrincipalCertificateAuthInfo withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the principalId property: Principal Id for servicePrincipal auth.
     *
     * @return the principalId value.
     */
    public String principalId() {
        return this.principalId;
    }

    /**
     * Set the principalId property: Principal Id for servicePrincipal auth.
     *
     * @param principalId the principalId value to set.
     * @return the ServicePrincipalCertificateAuthInfo object itself.
     */
    public ServicePrincipalCertificateAuthInfo withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    /**
     * Get the certificate property: ServicePrincipal certificate for servicePrincipal auth.
     *
     * @return the certificate value.
     */
    public String certificate() {
        return this.certificate;
    }

    /**
     * Set the certificate property: ServicePrincipal certificate for servicePrincipal auth.
     *
     * @param certificate the certificate value to set.
     * @return the ServicePrincipalCertificateAuthInfo object itself.
     */
    public ServicePrincipalCertificateAuthInfo withCertificate(String certificate) {
        this.certificate = certificate;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (clientId() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property clientId in model ServicePrincipalCertificateAuthInfo"));
        }
        if (principalId() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property principalId in model ServicePrincipalCertificateAuthInfo"));
        }
        if (certificate() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property certificate in model ServicePrincipalCertificateAuthInfo"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ServicePrincipalCertificateAuthInfo.class);
}
