// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicelinker.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** The authentication info when authType is servicePrincipal secret. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "authType")
@JsonTypeName("servicePrincipalSecret")
@Fluent
public final class ServicePrincipalSecretAuthInfo extends AuthInfoBase {
    /*
     * ServicePrincipal application clientId for servicePrincipal auth.
     */
    @JsonProperty(value = "clientId", required = true)
    private String clientId;

    /*
     * Principal Id for servicePrincipal auth.
     */
    @JsonProperty(value = "principalId", required = true)
    private String principalId;

    /*
     * Secret for servicePrincipal auth.
     */
    @JsonProperty(value = "secret", required = true)
    private String secret;

    /**
     * Get the clientId property: ServicePrincipal application clientId for servicePrincipal auth.
     *
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: ServicePrincipal application clientId for servicePrincipal auth.
     *
     * @param clientId the clientId value to set.
     * @return the ServicePrincipalSecretAuthInfo object itself.
     */
    public ServicePrincipalSecretAuthInfo withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the principalId property: Principal Id for servicePrincipal auth.
     *
     * @return the principalId value.
     */
    public String principalId() {
        return this.principalId;
    }

    /**
     * Set the principalId property: Principal Id for servicePrincipal auth.
     *
     * @param principalId the principalId value to set.
     * @return the ServicePrincipalSecretAuthInfo object itself.
     */
    public ServicePrincipalSecretAuthInfo withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    /**
     * Get the secret property: Secret for servicePrincipal auth.
     *
     * @return the secret value.
     */
    public String secret() {
        return this.secret;
    }

    /**
     * Set the secret property: Secret for servicePrincipal auth.
     *
     * @param secret the secret value to set.
     * @return the ServicePrincipalSecretAuthInfo object itself.
     */
    public ServicePrincipalSecretAuthInfo withSecret(String secret) {
        this.secret = secret;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (clientId() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property clientId in model ServicePrincipalSecretAuthInfo"));
        }
        if (principalId() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property principalId in model ServicePrincipalSecretAuthInfo"));
        }
        if (secret() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property secret in model ServicePrincipalSecretAuthInfo"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ServicePrincipalSecretAuthInfo.class);
}
