// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicelinker.models;

import com.azure.resourcemanager.servicelinker.fluent.models.ValidateOperationResultInner;
import java.time.OffsetDateTime;
import java.util.List;

/** An immutable client-side representation of ValidateOperationResult. */
public interface ValidateOperationResult {
    /**
     * Gets the resourceId property: Validated linker id.
     *
     * @return the resourceId value.
     */
    String resourceId();

    /**
     * Gets the status property: Validation operation status.
     *
     * @return the status value.
     */
    String status();

    /**
     * Gets the linkerName property: The linker name.
     *
     * @return the linkerName value.
     */
    String linkerName();

    /**
     * Gets the isConnectionAvailable property: A boolean value indicating whether the connection is available or not.
     *
     * @return the isConnectionAvailable value.
     */
    Boolean isConnectionAvailable();

    /**
     * Gets the reportStartTimeUtc property: The start time of the validation report.
     *
     * @return the reportStartTimeUtc value.
     */
    OffsetDateTime reportStartTimeUtc();

    /**
     * Gets the reportEndTimeUtc property: The end time of the validation report.
     *
     * @return the reportEndTimeUtc value.
     */
    OffsetDateTime reportEndTimeUtc();

    /**
     * Gets the sourceId property: The resource id of the linker source application.
     *
     * @return the sourceId value.
     */
    String sourceId();

    /**
     * Gets the targetId property: The resource Id of target service.
     *
     * @return the targetId value.
     */
    String targetId();

    /**
     * Gets the authType property: The authentication type.
     *
     * @return the authType value.
     */
    AuthType authType();

    /**
     * Gets the validationDetail property: The detail of validation result.
     *
     * @return the validationDetail value.
     */
    List<ValidationResultItem> validationDetail();

    /**
     * Gets the inner com.azure.resourcemanager.servicelinker.fluent.models.ValidateOperationResultInner object.
     *
     * @return the inner object.
     */
    ValidateOperationResultInner innerModel();
}
