// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicelinker.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for ValidationResultStatus. */
public final class ValidationResultStatus extends ExpandableStringEnum<ValidationResultStatus> {
    /** Static value success for ValidationResultStatus. */
    public static final ValidationResultStatus SUCCESS = fromString("success");

    /** Static value failure for ValidationResultStatus. */
    public static final ValidationResultStatus FAILURE = fromString("failure");

    /** Static value warning for ValidationResultStatus. */
    public static final ValidationResultStatus WARNING = fromString("warning");

    /**
     * Creates or finds a ValidationResultStatus from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ValidationResultStatus.
     */
    @JsonCreator
    public static ValidationResultStatus fromString(String name) {
        return fromString(name, ValidationResultStatus.class);
    }

    /**
     * Gets known ValidationResultStatus values.
     *
     * @return known ValidationResultStatus values.
     */
    public static Collection<ValidationResultStatus> values() {
        return values(ValidationResultStatus.class);
    }
}
