// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicelinker.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** The secret info when type is rawValue. It's for scenarios that user input the secret. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "secretType")
@JsonTypeName("rawValue")
@Fluent
public final class ValueSecretInfo extends SecretInfoBase {
    /*
     * The actual value of the secret.
     */
    @JsonProperty(value = "value")
    private String value;

    /**
     * Get the value property: The actual value of the secret.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The actual value of the secret.
     *
     * @param value the value value to set.
     * @return the ValueSecretInfo object itself.
     */
    public ValueSecretInfo withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
