/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicelinker.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.servicelinker.fluent.LinkersClient;
import com.azure.resourcemanager.servicelinker.fluent.models.LinkerResourceInner;
import com.azure.resourcemanager.servicelinker.fluent.models.SourceConfigurationResultInner;
import com.azure.resourcemanager.servicelinker.fluent.models.ValidateOperationResultInner;
import com.azure.resourcemanager.servicelinker.implementation.ServiceLinkerManagementClientImpl;
import com.azure.resourcemanager.servicelinker.models.LinkerList;
import com.azure.resourcemanager.servicelinker.models.LinkerPatch;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class LinkersClientImpl
implements LinkersClient {
    private final LinkersService service;
    private final ServiceLinkerManagementClientImpl client;

    LinkersClientImpl(ServiceLinkerManagementClientImpl client) {
        this.service = (LinkersService)RestProxy.create(LinkersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LinkerResourceInner>> listSinglePageAsync(String resourceUri) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceUri, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LinkerList)res.getValue()).value(), ((LinkerList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LinkerResourceInner>> listSinglePageAsync(String resourceUri, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceUri, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LinkerList)res.getValue()).value(), ((LinkerList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<LinkerResourceInner> listAsync(String resourceUri) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceUri), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<LinkerResourceInner> listAsync(String resourceUri, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceUri, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LinkerResourceInner> list(String resourceUri) {
        return new PagedIterable(this.listAsync(resourceUri));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LinkerResourceInner> list(String resourceUri, Context context) {
        return new PagedIterable(this.listAsync(resourceUri, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LinkerResourceInner>> getWithResponseAsync(String resourceUri, String linkerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (linkerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkerName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceUri, this.client.getApiVersion(), linkerName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LinkerResourceInner>> getWithResponseAsync(String resourceUri, String linkerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (linkerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkerName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceUri, this.client.getApiVersion(), linkerName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<LinkerResourceInner> getAsync(String resourceUri, String linkerName) {
        return this.getWithResponseAsync(resourceUri, linkerName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((LinkerResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkerResourceInner get(String resourceUri, String linkerName) {
        return (LinkerResourceInner)((Object)this.getAsync(resourceUri, linkerName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LinkerResourceInner> getWithResponse(String resourceUri, String linkerName, Context context) {
        return (Response)this.getWithResponseAsync(resourceUri, linkerName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceUri, String linkerName, LinkerResourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (linkerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkerName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceUri, this.client.getApiVersion(), linkerName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceUri, String linkerName, LinkerResourceInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (linkerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkerName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceUri, this.client.getApiVersion(), linkerName, parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<LinkerResourceInner>, LinkerResourceInner> beginCreateOrUpdateAsync(String resourceUri, String linkerName, LinkerResourceInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceUri, linkerName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)LinkerResourceInner.class), (Type)((Object)LinkerResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<LinkerResourceInner>, LinkerResourceInner> beginCreateOrUpdateAsync(String resourceUri, String linkerName, LinkerResourceInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceUri, linkerName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)LinkerResourceInner.class), (Type)((Object)LinkerResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<LinkerResourceInner>, LinkerResourceInner> beginCreateOrUpdate(String resourceUri, String linkerName, LinkerResourceInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceUri, linkerName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<LinkerResourceInner>, LinkerResourceInner> beginCreateOrUpdate(String resourceUri, String linkerName, LinkerResourceInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceUri, linkerName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<LinkerResourceInner> createOrUpdateAsync(String resourceUri, String linkerName, LinkerResourceInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceUri, linkerName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<LinkerResourceInner> createOrUpdateAsync(String resourceUri, String linkerName, LinkerResourceInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceUri, linkerName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkerResourceInner createOrUpdate(String resourceUri, String linkerName, LinkerResourceInner parameters) {
        return (LinkerResourceInner)((Object)this.createOrUpdateAsync(resourceUri, linkerName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkerResourceInner createOrUpdate(String resourceUri, String linkerName, LinkerResourceInner parameters, Context context) {
        return (LinkerResourceInner)((Object)this.createOrUpdateAsync(resourceUri, linkerName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceUri, String linkerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (linkerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkerName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceUri, this.client.getApiVersion(), linkerName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceUri, String linkerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (linkerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkerName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceUri, this.client.getApiVersion(), linkerName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceUri, String linkerName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceUri, linkerName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceUri, String linkerName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceUri, linkerName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceUri, String linkerName) {
        return this.beginDeleteAsync(resourceUri, linkerName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceUri, String linkerName, Context context) {
        return this.beginDeleteAsync(resourceUri, linkerName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceUri, String linkerName) {
        return this.beginDeleteAsync(resourceUri, linkerName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceUri, String linkerName, Context context) {
        return this.beginDeleteAsync(resourceUri, linkerName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceUri, String linkerName) {
        this.deleteAsync(resourceUri, linkerName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceUri, String linkerName, Context context) {
        this.deleteAsync(resourceUri, linkerName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceUri, String linkerName, LinkerPatch parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (linkerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkerName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceUri, this.client.getApiVersion(), linkerName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceUri, String linkerName, LinkerPatch parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (linkerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkerName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceUri, this.client.getApiVersion(), linkerName, parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<LinkerResourceInner>, LinkerResourceInner> beginUpdateAsync(String resourceUri, String linkerName, LinkerPatch parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceUri, linkerName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)LinkerResourceInner.class), (Type)((Object)LinkerResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<LinkerResourceInner>, LinkerResourceInner> beginUpdateAsync(String resourceUri, String linkerName, LinkerPatch parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceUri, linkerName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)LinkerResourceInner.class), (Type)((Object)LinkerResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<LinkerResourceInner>, LinkerResourceInner> beginUpdate(String resourceUri, String linkerName, LinkerPatch parameters) {
        return this.beginUpdateAsync(resourceUri, linkerName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<LinkerResourceInner>, LinkerResourceInner> beginUpdate(String resourceUri, String linkerName, LinkerPatch parameters, Context context) {
        return this.beginUpdateAsync(resourceUri, linkerName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<LinkerResourceInner> updateAsync(String resourceUri, String linkerName, LinkerPatch parameters) {
        return this.beginUpdateAsync(resourceUri, linkerName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<LinkerResourceInner> updateAsync(String resourceUri, String linkerName, LinkerPatch parameters, Context context) {
        return this.beginUpdateAsync(resourceUri, linkerName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkerResourceInner update(String resourceUri, String linkerName, LinkerPatch parameters) {
        return (LinkerResourceInner)((Object)this.updateAsync(resourceUri, linkerName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkerResourceInner update(String resourceUri, String linkerName, LinkerPatch parameters, Context context) {
        return (LinkerResourceInner)((Object)this.updateAsync(resourceUri, linkerName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateWithResponseAsync(String resourceUri, String linkerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (linkerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkerName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validate(this.client.getEndpoint(), resourceUri, this.client.getApiVersion(), linkerName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateWithResponseAsync(String resourceUri, String linkerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (linkerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkerName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validate(this.client.getEndpoint(), resourceUri, this.client.getApiVersion(), linkerName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ValidateOperationResultInner>, ValidateOperationResultInner> beginValidateAsync(String resourceUri, String linkerName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateWithResponseAsync(resourceUri, linkerName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ValidateOperationResultInner.class), (Type)((Object)ValidateOperationResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ValidateOperationResultInner>, ValidateOperationResultInner> beginValidateAsync(String resourceUri, String linkerName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateWithResponseAsync(resourceUri, linkerName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ValidateOperationResultInner.class), (Type)((Object)ValidateOperationResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ValidateOperationResultInner>, ValidateOperationResultInner> beginValidate(String resourceUri, String linkerName) {
        return this.beginValidateAsync(resourceUri, linkerName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ValidateOperationResultInner>, ValidateOperationResultInner> beginValidate(String resourceUri, String linkerName, Context context) {
        return this.beginValidateAsync(resourceUri, linkerName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ValidateOperationResultInner> validateAsync(String resourceUri, String linkerName) {
        return this.beginValidateAsync(resourceUri, linkerName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ValidateOperationResultInner> validateAsync(String resourceUri, String linkerName, Context context) {
        return this.beginValidateAsync(resourceUri, linkerName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ValidateOperationResultInner validate(String resourceUri, String linkerName) {
        return (ValidateOperationResultInner)this.validateAsync(resourceUri, linkerName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ValidateOperationResultInner validate(String resourceUri, String linkerName, Context context) {
        return (ValidateOperationResultInner)this.validateAsync(resourceUri, linkerName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SourceConfigurationResultInner>> listConfigurationsWithResponseAsync(String resourceUri, String linkerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (linkerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkerName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listConfigurations(this.client.getEndpoint(), resourceUri, this.client.getApiVersion(), linkerName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SourceConfigurationResultInner>> listConfigurationsWithResponseAsync(String resourceUri, String linkerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (linkerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkerName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listConfigurations(this.client.getEndpoint(), resourceUri, this.client.getApiVersion(), linkerName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SourceConfigurationResultInner> listConfigurationsAsync(String resourceUri, String linkerName) {
        return this.listConfigurationsWithResponseAsync(resourceUri, linkerName).flatMap(res -> Mono.justOrEmpty((Object)((SourceConfigurationResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SourceConfigurationResultInner listConfigurations(String resourceUri, String linkerName) {
        return (SourceConfigurationResultInner)this.listConfigurationsAsync(resourceUri, linkerName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SourceConfigurationResultInner> listConfigurationsWithResponse(String resourceUri, String linkerName, Context context) {
        return (Response)this.listConfigurationsWithResponseAsync(resourceUri, linkerName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LinkerResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LinkerList)res.getValue()).value(), ((LinkerList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LinkerResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LinkerList)res.getValue()).value(), ((LinkerList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ServiceLinkerManagem")
    private static interface LinkersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.ServiceLinker/linkers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LinkerList>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.ServiceLinker/linkers/{linkerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LinkerResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="api-version") String var3, @PathParam(value="linkerName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{resourceUri}/providers/Microsoft.ServiceLinker/linkers/{linkerName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="api-version") String var3, @PathParam(value="linkerName") String var4, @BodyParam(value="application/json") LinkerResourceInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/{resourceUri}/providers/Microsoft.ServiceLinker/linkers/{linkerName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="api-version") String var3, @PathParam(value="linkerName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/{resourceUri}/providers/Microsoft.ServiceLinker/linkers/{linkerName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="api-version") String var3, @PathParam(value="linkerName") String var4, @BodyParam(value="application/json") LinkerPatch var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{resourceUri}/providers/Microsoft.ServiceLinker/linkers/{linkerName}/validateLinker")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> validate(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="api-version") String var3, @PathParam(value="linkerName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{resourceUri}/providers/Microsoft.ServiceLinker/linkers/{linkerName}/listConfigurations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SourceConfigurationResultInner>> listConfigurations(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="api-version") String var3, @PathParam(value="linkerName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LinkerList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

