/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicelinker.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.servicelinker.ServiceLinkerManager;
import com.azure.resourcemanager.servicelinker.fluent.OperationsClient;
import com.azure.resourcemanager.servicelinker.fluent.models.OperationInner;
import com.azure.resourcemanager.servicelinker.implementation.OperationImpl;
import com.azure.resourcemanager.servicelinker.implementation.Utils;
import com.azure.resourcemanager.servicelinker.models.Operation;
import com.azure.resourcemanager.servicelinker.models.Operations;

public final class OperationsImpl
implements Operations {
    private static final ClientLogger LOGGER = new ClientLogger(OperationsImpl.class);
    private final OperationsClient innerClient;
    private final ServiceLinkerManager serviceManager;

    public OperationsImpl(OperationsClient innerClient, ServiceLinkerManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Operation> list() {
        PagedIterable<OperationInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new OperationImpl((OperationInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<Operation> list(Context context) {
        PagedIterable<OperationInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new OperationImpl((OperationInner)inner1, this.manager()));
    }

    private OperationsClient serviceClient() {
        return this.innerClient;
    }

    private ServiceLinkerManager manager() {
        return this.serviceManager;
    }
}

