/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.JobExecutionsClient;
import com.azure.resourcemanager.sql.fluent.models.JobExecutionInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.JobExecutionListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.UUID;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class JobExecutionsClientImpl
implements JobExecutionsClient {
    private final ClientLogger logger = new ClientLogger(JobExecutionsClientImpl.class);
    private final JobExecutionsService service;
    private final SqlManagementClientImpl client;

    JobExecutionsClientImpl(SqlManagementClientImpl client) {
        this.service = (JobExecutionsService)RestProxy.create(JobExecutionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<JobExecutionInner>> listByAgentSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.listByAgent(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobExecutionListResult)res.getValue()).value(), ((JobExecutionListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<JobExecutionInner>> listByAgentSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Integer skip, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.listByAgent(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, this.client.getSubscriptionId(), "2017-03-01-preview", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobExecutionListResult)res.getValue()).value(), ((JobExecutionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<JobExecutionInner> listByAgentAsync(String resourceGroupName, String serverName, String jobAgentName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        return new PagedFlux(() -> this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top), nextLink -> this.listByAgentNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<JobExecutionInner> listByAgentAsync(String resourceGroupName, String serverName, String jobAgentName) {
        OffsetDateTime createTimeMin = null;
        OffsetDateTime createTimeMax = null;
        OffsetDateTime endTimeMin = null;
        OffsetDateTime endTimeMax = null;
        Boolean isActive = null;
        Integer skip = null;
        Integer top = null;
        return new PagedFlux(() -> this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top), nextLink -> this.listByAgentNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<JobExecutionInner> listByAgentAsync(String resourceGroupName, String serverName, String jobAgentName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Integer skip, Integer top, Context context) {
        return new PagedFlux(() -> this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, context), nextLink -> this.listByAgentNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<JobExecutionInner> listByAgent(String resourceGroupName, String serverName, String jobAgentName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Integer skip, Integer top, Context context) {
        return new PagedIterable(this.listByAgentAsync(resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, context));
    }

    @Override
    public PagedIterable<JobExecutionInner> listByAgent(String resourceGroupName, String serverName, String jobAgentName) {
        OffsetDateTime createTimeMin = null;
        OffsetDateTime createTimeMax = null;
        OffsetDateTime endTimeMin = null;
        OffsetDateTime endTimeMax = null;
        Boolean isActive = null;
        Integer skip = null;
        Integer top = null;
        return new PagedIterable(this.listByAgentAsync(resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top));
    }

    @Override
    public Mono<Response<Void>> cancelWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.cancel(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> cancelWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.cancel(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.getSubscriptionId(), "2017-03-01-preview", context);
    }

    @Override
    public Mono<Void> cancelAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return this.cancelWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).flatMap(res -> Mono.empty());
    }

    @Override
    public void cancel(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        this.cancelAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).block();
    }

    @Override
    public Response<Void> cancelWithResponse(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, Context context) {
        return (Response)this.cancelWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, this.client.getSubscriptionId(), "2017-03-01-preview", context);
    }

    @Override
    public PollerFlux<PollResult<JobExecutionInner>, JobExecutionInner> beginCreateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)JobExecutionInner.class), (Type)((Object)JobExecutionInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<JobExecutionInner>, JobExecutionInner> beginCreateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)JobExecutionInner.class), (Type)((Object)JobExecutionInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<JobExecutionInner>, JobExecutionInner> beginCreate(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return this.beginCreateAsync(resourceGroupName, serverName, jobAgentName, jobName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<JobExecutionInner>, JobExecutionInner> beginCreate(String resourceGroupName, String serverName, String jobAgentName, String jobName, Context context) {
        return this.beginCreateAsync(resourceGroupName, serverName, jobAgentName, jobName, context).getSyncPoller();
    }

    @Override
    public Mono<JobExecutionInner> createAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return this.beginCreateAsync(resourceGroupName, serverName, jobAgentName, jobName).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<JobExecutionInner> createAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, Context context) {
        return this.beginCreateAsync(resourceGroupName, serverName, jobAgentName, jobName, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public JobExecutionInner create(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return (JobExecutionInner)((Object)this.createAsync(resourceGroupName, serverName, jobAgentName, jobName).block());
    }

    @Override
    public JobExecutionInner create(String resourceGroupName, String serverName, String jobAgentName, String jobName, Context context) {
        return (JobExecutionInner)((Object)this.createAsync(resourceGroupName, serverName, jobAgentName, jobName, context).block());
    }

    private Mono<PagedResponse<JobExecutionInner>> listByJobSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.listByJob(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobExecutionListResult)res.getValue()).value(), ((JobExecutionListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<JobExecutionInner>> listByJobSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Integer skip, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.listByJob(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, this.client.getSubscriptionId(), "2017-03-01-preview", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobExecutionListResult)res.getValue()).value(), ((JobExecutionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<JobExecutionInner> listByJobAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        return new PagedFlux(() -> this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top), nextLink -> this.listByJobNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<JobExecutionInner> listByJobAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        OffsetDateTime createTimeMin = null;
        OffsetDateTime createTimeMax = null;
        OffsetDateTime endTimeMin = null;
        OffsetDateTime endTimeMax = null;
        Boolean isActive = null;
        Integer skip = null;
        Integer top = null;
        return new PagedFlux(() -> this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top), nextLink -> this.listByJobNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<JobExecutionInner> listByJobAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Integer skip, Integer top, Context context) {
        return new PagedFlux(() -> this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, context), nextLink -> this.listByJobNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<JobExecutionInner> listByJob(String resourceGroupName, String serverName, String jobAgentName, String jobName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Integer skip, Integer top, Context context) {
        return new PagedIterable(this.listByJobAsync(resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, context));
    }

    @Override
    public PagedIterable<JobExecutionInner> listByJob(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        OffsetDateTime createTimeMin = null;
        OffsetDateTime createTimeMax = null;
        OffsetDateTime endTimeMin = null;
        OffsetDateTime endTimeMax = null;
        Boolean isActive = null;
        Integer skip = null;
        Integer top = null;
        return new PagedIterable(this.listByJobAsync(resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top));
    }

    @Override
    public Mono<Response<JobExecutionInner>> getWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<JobExecutionInner>> getWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.getSubscriptionId(), "2017-03-01-preview", context);
    }

    @Override
    public Mono<JobExecutionInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return this.getWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((JobExecutionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public JobExecutionInner get(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return (JobExecutionInner)((Object)this.getAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).block());
    }

    @Override
    public Response<JobExecutionInner> getWithResponse(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.getSubscriptionId(), "2017-03-01-preview", context);
    }

    @Override
    public PollerFlux<PollResult<JobExecutionInner>, JobExecutionInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)JobExecutionInner.class), (Type)((Object)JobExecutionInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<JobExecutionInner>, JobExecutionInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)JobExecutionInner.class), (Type)((Object)JobExecutionInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<JobExecutionInner>, JobExecutionInner> beginCreateOrUpdate(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<JobExecutionInner>, JobExecutionInner> beginCreateOrUpdate(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, context).getSyncPoller();
    }

    @Override
    public Mono<JobExecutionInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<JobExecutionInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public JobExecutionInner createOrUpdate(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return (JobExecutionInner)((Object)this.createOrUpdateAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).block());
    }

    @Override
    public JobExecutionInner createOrUpdate(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, Context context) {
        return (JobExecutionInner)((Object)this.createOrUpdateAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, context).block());
    }

    private Mono<PagedResponse<JobExecutionInner>> listByAgentNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByAgentNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobExecutionListResult)res.getValue()).value(), ((JobExecutionListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<JobExecutionInner>> listByAgentNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByAgentNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobExecutionListResult)res.getValue()).value(), ((JobExecutionListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<JobExecutionInner>> listByJobNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByJobNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobExecutionListResult)res.getValue()).value(), ((JobExecutionListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<JobExecutionInner>> listByJobNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByJobNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobExecutionListResult)res.getValue()).value(), ((JobExecutionListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientJ")
    private static interface JobExecutionsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/executions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobExecutionListResult>> listByAgent(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="jobAgentName") String var4, @QueryParam(value="createTimeMin") OffsetDateTime var5, @QueryParam(value="createTimeMax") OffsetDateTime var6, @QueryParam(value="endTimeMin") OffsetDateTime var7, @QueryParam(value="endTimeMax") OffsetDateTime var8, @QueryParam(value="isActive") Boolean var9, @QueryParam(value="$skip") Integer var10, @QueryParam(value="$top") Integer var11, @PathParam(value="subscriptionId") String var12, @QueryParam(value="api-version") String var13, Context var14);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> cancel(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="jobAgentName") String var4, @PathParam(value="jobName") String var5, @PathParam(value="jobExecutionId") UUID var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/start")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="jobAgentName") String var4, @PathParam(value="jobName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobExecutionListResult>> listByJob(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="jobAgentName") String var4, @PathParam(value="jobName") String var5, @QueryParam(value="createTimeMin") OffsetDateTime var6, @QueryParam(value="createTimeMax") OffsetDateTime var7, @QueryParam(value="endTimeMin") OffsetDateTime var8, @QueryParam(value="endTimeMax") OffsetDateTime var9, @QueryParam(value="isActive") Boolean var10, @QueryParam(value="$skip") Integer var11, @QueryParam(value="$top") Integer var12, @PathParam(value="subscriptionId") String var13, @QueryParam(value="api-version") String var14, Context var15);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobExecutionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="jobAgentName") String var4, @PathParam(value="jobName") String var5, @PathParam(value="jobExecutionId") UUID var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="jobAgentName") String var4, @PathParam(value="jobName") String var5, @PathParam(value="jobExecutionId") UUID var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobExecutionListResult>> listByAgentNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobExecutionListResult>> listByJobNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

