/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.sql.fluent.ManagedInstanceAdministratorsClient;
import com.azure.resourcemanager.sql.fluent.models.ManagedInstanceAdministratorInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.ManagedInstanceAdministratorListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ManagedInstanceAdministratorsClientImpl
implements InnerSupportsDelete<Void>,
ManagedInstanceAdministratorsClient {
    private final ClientLogger logger = new ClientLogger(ManagedInstanceAdministratorsClientImpl.class);
    private final ManagedInstanceAdministratorsService service;
    private final SqlManagementClientImpl client;

    ManagedInstanceAdministratorsClientImpl(SqlManagementClientImpl client) {
        this.service = (ManagedInstanceAdministratorsService)RestProxy.create(ManagedInstanceAdministratorsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<ManagedInstanceAdministratorInner>> listByInstanceSinglePageAsync(String resourceGroupName, String managedInstanceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.listByInstance(this.client.getEndpoint(), resourceGroupName, managedInstanceName, this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedInstanceAdministratorListResult)res.getValue()).value(), ((ManagedInstanceAdministratorListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ManagedInstanceAdministratorInner>> listByInstanceSinglePageAsync(String resourceGroupName, String managedInstanceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.listByInstance(this.client.getEndpoint(), resourceGroupName, managedInstanceName, this.client.getSubscriptionId(), "2017-03-01-preview", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedInstanceAdministratorListResult)res.getValue()).value(), ((ManagedInstanceAdministratorListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<ManagedInstanceAdministratorInner> listByInstanceAsync(String resourceGroupName, String managedInstanceName) {
        return new PagedFlux(() -> this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName), nextLink -> this.listByInstanceNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<ManagedInstanceAdministratorInner> listByInstanceAsync(String resourceGroupName, String managedInstanceName, Context context) {
        return new PagedFlux(() -> this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName, context), nextLink -> this.listByInstanceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<ManagedInstanceAdministratorInner> listByInstance(String resourceGroupName, String managedInstanceName) {
        return new PagedIterable(this.listByInstanceAsync(resourceGroupName, managedInstanceName));
    }

    @Override
    public PagedIterable<ManagedInstanceAdministratorInner> listByInstance(String resourceGroupName, String managedInstanceName, Context context) {
        return new PagedIterable(this.listByInstanceAsync(resourceGroupName, managedInstanceName, context));
    }

    @Override
    public Mono<Response<ManagedInstanceAdministratorInner>> getWithResponseAsync(String resourceGroupName, String managedInstanceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String administratorName = "ActiveDirectory";
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, managedInstanceName, "ActiveDirectory", this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ManagedInstanceAdministratorInner>> getWithResponseAsync(String resourceGroupName, String managedInstanceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String administratorName = "ActiveDirectory";
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, managedInstanceName, "ActiveDirectory", this.client.getSubscriptionId(), "2017-03-01-preview", context);
    }

    @Override
    public Mono<ManagedInstanceAdministratorInner> getAsync(String resourceGroupName, String managedInstanceName) {
        return this.getWithResponseAsync(resourceGroupName, managedInstanceName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ManagedInstanceAdministratorInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ManagedInstanceAdministratorInner get(String resourceGroupName, String managedInstanceName) {
        return (ManagedInstanceAdministratorInner)((Object)this.getAsync(resourceGroupName, managedInstanceName).block());
    }

    @Override
    public Response<ManagedInstanceAdministratorInner> getWithResponse(String resourceGroupName, String managedInstanceName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, managedInstanceName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceAdministratorInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String administratorName = "ActiveDirectory";
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, managedInstanceName, "ActiveDirectory", this.client.getSubscriptionId(), "2017-03-01-preview", parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceAdministratorInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String administratorName = "ActiveDirectory";
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, managedInstanceName, "ActiveDirectory", this.client.getSubscriptionId(), "2017-03-01-preview", parameters, context);
    }

    @Override
    public PollerFlux<PollResult<ManagedInstanceAdministratorInner>, ManagedInstanceAdministratorInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceAdministratorInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, managedInstanceName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ManagedInstanceAdministratorInner.class), (Type)((Object)ManagedInstanceAdministratorInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ManagedInstanceAdministratorInner>, ManagedInstanceAdministratorInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceAdministratorInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, managedInstanceName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ManagedInstanceAdministratorInner.class), (Type)((Object)ManagedInstanceAdministratorInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ManagedInstanceAdministratorInner>, ManagedInstanceAdministratorInner> beginCreateOrUpdate(String resourceGroupName, String managedInstanceName, ManagedInstanceAdministratorInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, parameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ManagedInstanceAdministratorInner>, ManagedInstanceAdministratorInner> beginCreateOrUpdate(String resourceGroupName, String managedInstanceName, ManagedInstanceAdministratorInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, parameters, context).getSyncPoller();
    }

    @Override
    public Mono<ManagedInstanceAdministratorInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceAdministratorInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, parameters).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ManagedInstanceAdministratorInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceAdministratorInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, parameters, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ManagedInstanceAdministratorInner createOrUpdate(String resourceGroupName, String managedInstanceName, ManagedInstanceAdministratorInner parameters) {
        return (ManagedInstanceAdministratorInner)((Object)this.createOrUpdateAsync(resourceGroupName, managedInstanceName, parameters).block());
    }

    @Override
    public ManagedInstanceAdministratorInner createOrUpdate(String resourceGroupName, String managedInstanceName, ManagedInstanceAdministratorInner parameters, Context context) {
        return (ManagedInstanceAdministratorInner)((Object)this.createOrUpdateAsync(resourceGroupName, managedInstanceName, parameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String managedInstanceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String administratorName = "ActiveDirectory";
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, managedInstanceName, "ActiveDirectory", this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String managedInstanceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String administratorName = "ActiveDirectory";
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, managedInstanceName, "ActiveDirectory", this.client.getSubscriptionId(), "2017-03-01-preview", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String managedInstanceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, managedInstanceName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String managedInstanceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, managedInstanceName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String managedInstanceName) {
        return this.beginDeleteAsync(resourceGroupName, managedInstanceName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String managedInstanceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, managedInstanceName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String managedInstanceName) {
        return this.beginDeleteAsync(resourceGroupName, managedInstanceName).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String managedInstanceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, managedInstanceName, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void delete(String resourceGroupName, String managedInstanceName) {
        this.deleteAsync(resourceGroupName, managedInstanceName).block();
    }

    @Override
    public void delete(String resourceGroupName, String managedInstanceName, Context context) {
        this.deleteAsync(resourceGroupName, managedInstanceName, context).block();
    }

    private Mono<PagedResponse<ManagedInstanceAdministratorInner>> listByInstanceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByInstanceNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedInstanceAdministratorListResult)res.getValue()).value(), ((ManagedInstanceAdministratorListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ManagedInstanceAdministratorInner>> listByInstanceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByInstanceNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedInstanceAdministratorListResult)res.getValue()).value(), ((ManagedInstanceAdministratorListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientM")
    private static interface ManagedInstanceAdministratorsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/administrators")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedInstanceAdministratorListResult>> listByInstance(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/administrators/{administratorName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedInstanceAdministratorInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="administratorName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/administrators/{administratorName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="administratorName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ManagedInstanceAdministratorInner var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/administrators/{administratorName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="administratorName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedInstanceAdministratorListResult>> listByInstanceNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

