/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.ServerDnsAliasInner;
import com.azure.resourcemanager.sql.implementation.SqlChildrenOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerDnsAliasImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.models.SqlServer;
import com.azure.resourcemanager.sql.models.SqlServerDnsAlias;
import com.azure.resourcemanager.sql.models.SqlServerDnsAliasOperations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlServerDnsAliasOperationsImpl
extends SqlChildrenOperationsImpl<SqlServerDnsAlias>
implements SqlServerDnsAliasOperations,
SqlServerDnsAliasOperations.SqlServerDnsAliasActionsDefinition {
    private static final String DNS_ALIASES = "/dnsAliases/";

    SqlServerDnsAliasOperationsImpl(SqlServer parent, SqlServerManager sqlServerManager) {
        super(parent, sqlServerManager);
        Objects.requireNonNull(parent);
    }

    SqlServerDnsAliasOperationsImpl(SqlServerManager sqlServerManager) {
        super(null, sqlServerManager);
    }

    @Override
    public SqlServerDnsAlias getBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        ServerDnsAliasInner serverDnsAliasInner = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerDnsAliases().get(resourceGroupName, sqlServerName, name);
        return serverDnsAliasInner != null ? new SqlServerDnsAliasImpl(resourceGroupName, sqlServerName, name, serverDnsAliasInner, this.sqlServerManager) : null;
    }

    @Override
    public Mono<SqlServerDnsAlias> getBySqlServerAsync(String resourceGroupName, String sqlServerName, String name) {
        SqlServerDnsAliasOperationsImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerDnsAliases().getAsync(resourceGroupName, sqlServerName, name).map(serverDnsAliasInner -> new SqlServerDnsAliasImpl(resourceGroupName, sqlServerName, name, (ServerDnsAliasInner)((Object)serverDnsAliasInner), self.sqlServerManager));
    }

    @Override
    public SqlServerDnsAlias getBySqlServer(SqlServer sqlServer, String name) {
        Objects.requireNonNull(sqlServer);
        ServerDnsAliasInner serverDnsAliasInner = ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getServerDnsAliases().get(sqlServer.resourceGroupName(), sqlServer.name(), name);
        return serverDnsAliasInner != null ? new SqlServerDnsAliasImpl(name, (SqlServerImpl)sqlServer, serverDnsAliasInner, (SqlServerManager)((Object)sqlServer.manager())) : null;
    }

    @Override
    public Mono<SqlServerDnsAlias> getBySqlServerAsync(SqlServer sqlServer, String name) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getServerDnsAliases().getAsync(sqlServer.resourceGroupName(), sqlServer.name(), name).map(serverDnsAliasInner -> new SqlServerDnsAliasImpl(name, (SqlServerImpl)sqlServer, (ServerDnsAliasInner)((Object)serverDnsAliasInner), (SqlServerManager)((Object)((Object)sqlServer.manager()))));
    }

    @Override
    public void deleteBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerDnsAliases().delete(resourceGroupName, sqlServerName, name);
    }

    @Override
    public Mono<Void> deleteBySqlServerAsync(String resourceGroupName, String sqlServerName, String name) {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerDnsAliases().deleteAsync(resourceGroupName, sqlServerName, name);
    }

    @Override
    public List<SqlServerDnsAlias> listBySqlServer(String resourceGroupName, String sqlServerName) {
        ArrayList<SqlServerDnsAliasImpl> serverDnsAliases = new ArrayList<SqlServerDnsAliasImpl>();
        PagedIterable<ServerDnsAliasInner> serverDnsAliasInners = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerDnsAliases().listByServer(resourceGroupName, sqlServerName);
        for (ServerDnsAliasInner inner : serverDnsAliasInners) {
            serverDnsAliases.add(new SqlServerDnsAliasImpl(resourceGroupName, sqlServerName, inner.name(), inner, this.sqlServerManager));
        }
        return Collections.unmodifiableList(serverDnsAliases);
    }

    @Override
    public PagedFlux<SqlServerDnsAlias> listBySqlServerAsync(String resourceGroupName, String sqlServerName) {
        SqlServerDnsAliasOperationsImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerDnsAliases().listByServerAsync(resourceGroupName, sqlServerName).mapPage(serverDnsAliasInner -> new SqlServerDnsAliasImpl(resourceGroupName, sqlServerName, serverDnsAliasInner.name(), (ServerDnsAliasInner)((Object)serverDnsAliasInner), self.sqlServerManager));
    }

    @Override
    public List<SqlServerDnsAlias> listBySqlServer(SqlServer sqlServer) {
        ArrayList<SqlServerDnsAliasImpl> serverDnsAliases = new ArrayList<SqlServerDnsAliasImpl>();
        PagedIterable<ServerDnsAliasInner> serverDnsAliasInners = ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getServerDnsAliases().listByServer(sqlServer.resourceGroupName(), sqlServer.name());
        for (ServerDnsAliasInner inner : serverDnsAliasInners) {
            serverDnsAliases.add(new SqlServerDnsAliasImpl(inner.name(), (SqlServerImpl)sqlServer, inner, this.sqlServerManager));
        }
        return Collections.unmodifiableList(serverDnsAliases);
    }

    @Override
    public PagedFlux<SqlServerDnsAlias> listBySqlServerAsync(SqlServer sqlServer) {
        return ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getServerDnsAliases().listByServerAsync(sqlServer.resourceGroupName(), sqlServer.name()).mapPage(serverDnsAliasInner -> new SqlServerDnsAliasImpl(serverDnsAliasInner.name(), (SqlServerImpl)sqlServer, (ServerDnsAliasInner)((Object)serverDnsAliasInner), (SqlServerManager)((Object)((Object)sqlServer.manager()))));
    }

    @Override
    public void acquire(String resourceGroupName, String serverName, String dnsAliasName, String sqlServerId) {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerDnsAliases().acquire(resourceGroupName, serverName, dnsAliasName, sqlServerId + DNS_ALIASES + dnsAliasName);
    }

    @Override
    public Mono<Void> acquireAsync(String resourceGroupName, String serverName, String dnsAliasName, String sqlServerId) {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerDnsAliases().acquireAsync(resourceGroupName, serverName, dnsAliasName, sqlServerId + DNS_ALIASES + dnsAliasName);
    }

    @Override
    public void acquire(String dnsAliasName, String oldSqlServerId, String newSqlServerId) {
        Objects.requireNonNull(oldSqlServerId);
        ResourceId resourceId = ResourceId.fromString((String)oldSqlServerId);
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerDnsAliases().acquire(resourceId.resourceGroupName(), resourceId.name(), dnsAliasName, newSqlServerId + DNS_ALIASES + dnsAliasName);
    }

    @Override
    public Mono<Void> acquireAsync(String dnsAliasName, String oldSqlServerId, String newSqlServerId) {
        Objects.requireNonNull(oldSqlServerId);
        ResourceId resourceId = ResourceId.fromString((String)oldSqlServerId);
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerDnsAliases().acquireAsync(resourceId.resourceGroupName(), resourceId.name(), dnsAliasName, newSqlServerId + DNS_ALIASES + dnsAliasName);
    }

    @Override
    public SqlServerDnsAliasImpl define(String name) {
        SqlServerDnsAliasImpl result = new SqlServerDnsAliasImpl(name, new ServerDnsAliasInner(), this.sqlServerManager);
        result.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        return this.sqlServer != null ? result.withExistingSqlServer(this.sqlServer) : result;
    }

    @Override
    public void acquire(String dnsAliasName, String sqlServerId) {
        this.acquire(this.sqlServer.resourceGroupName(), this.sqlServer.name(), dnsAliasName, sqlServerId);
    }

    @Override
    public Mono<Void> acquireAsync(String dnsAliasName, String sqlServerId) {
        return this.acquireAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name(), dnsAliasName, sqlServerId);
    }
}

