/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Resource;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.dag.FunctionalTaskItem;
import com.azure.resourcemanager.resources.fluentcore.dag.TaskGroup;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.RecommendedElasticPoolInner;
import com.azure.resourcemanager.sql.fluent.models.RestorableDroppedDatabaseInner;
import com.azure.resourcemanager.sql.fluent.models.ServerAutomaticTuningInner;
import com.azure.resourcemanager.sql.fluent.models.ServerAzureADAdministratorInner;
import com.azure.resourcemanager.sql.fluent.models.ServerInner;
import com.azure.resourcemanager.sql.fluent.models.ServerUsageInner;
import com.azure.resourcemanager.sql.fluent.models.ServiceObjectiveInner;
import com.azure.resourcemanager.sql.implementation.RecommendedElasticPoolImpl;
import com.azure.resourcemanager.sql.implementation.ServerMetricImpl;
import com.azure.resourcemanager.sql.implementation.ServiceObjectiveImpl;
import com.azure.resourcemanager.sql.implementation.SqlActiveDirectoryAdministratorImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabasesAsExternalChildResourcesImpl;
import com.azure.resourcemanager.sql.implementation.SqlElasticPoolImpl;
import com.azure.resourcemanager.sql.implementation.SqlElasticPoolOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlElasticPoolsAsExternalChildResourcesImpl;
import com.azure.resourcemanager.sql.implementation.SqlEncryptionProtectorOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlFailoverGroupOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlFirewallRuleImpl;
import com.azure.resourcemanager.sql.implementation.SqlFirewallRuleOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlFirewallRulesAsExternalChildResourcesImpl;
import com.azure.resourcemanager.sql.implementation.SqlRestorableDroppedDatabaseImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerAutomaticTuningImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerDnsAliasOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerKeyOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerSecurityAlertPolicyOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlVirtualNetworkRuleOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlVirtualNetworkRulesAsExternalChildResourcesImpl;
import com.azure.resourcemanager.sql.models.AdministratorName;
import com.azure.resourcemanager.sql.models.IdentityType;
import com.azure.resourcemanager.sql.models.RecommendedElasticPool;
import com.azure.resourcemanager.sql.models.ResourceIdentity;
import com.azure.resourcemanager.sql.models.ServerMetric;
import com.azure.resourcemanager.sql.models.ServiceObjective;
import com.azure.resourcemanager.sql.models.SqlDatabaseOperations;
import com.azure.resourcemanager.sql.models.SqlElasticPoolOperations;
import com.azure.resourcemanager.sql.models.SqlEncryptionProtectorOperations;
import com.azure.resourcemanager.sql.models.SqlFailoverGroupOperations;
import com.azure.resourcemanager.sql.models.SqlFirewallRule;
import com.azure.resourcemanager.sql.models.SqlFirewallRuleOperations;
import com.azure.resourcemanager.sql.models.SqlRestorableDroppedDatabase;
import com.azure.resourcemanager.sql.models.SqlServer;
import com.azure.resourcemanager.sql.models.SqlServerAutomaticTuning;
import com.azure.resourcemanager.sql.models.SqlServerDnsAliasOperations;
import com.azure.resourcemanager.sql.models.SqlServerKeyOperations;
import com.azure.resourcemanager.sql.models.SqlServerSecurityAlertPolicyOperations;
import com.azure.resourcemanager.sql.models.SqlVirtualNetworkRule;
import com.azure.resourcemanager.sql.models.SqlVirtualNetworkRuleOperations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import reactor.core.publisher.Mono;

public class SqlServerImpl
extends GroupableResourceImpl<SqlServer, ServerInner, SqlServerImpl, SqlServerManager>
implements SqlServer,
SqlServer.Definition,
SqlServer.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private FunctionalTaskItem sqlADAdminCreator = null;
    private boolean allowAzureServicesAccess = true;
    private SqlFirewallRulesAsExternalChildResourcesImpl sqlFirewallRules = new SqlFirewallRulesAsExternalChildResourcesImpl(this, "SqlFirewallRule");
    private SqlFirewallRuleOperations.SqlFirewallRuleActionsDefinition sqlFirewallRuleOperations;
    private SqlVirtualNetworkRulesAsExternalChildResourcesImpl sqlVirtualNetworkRules = new SqlVirtualNetworkRulesAsExternalChildResourcesImpl(this, "SqlVirtualNetworkRule");
    private SqlVirtualNetworkRuleOperations.SqlVirtualNetworkRuleActionsDefinition sqlVirtualNetworkRuleOperations;
    private SqlElasticPoolsAsExternalChildResourcesImpl sqlElasticPools = new SqlElasticPoolsAsExternalChildResourcesImpl(this, "SqlElasticPool");
    private SqlElasticPoolOperations.SqlElasticPoolActionsDefinition sqlElasticPoolOperations;
    private SqlDatabasesAsExternalChildResourcesImpl sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(this, "SqlDatabase");
    private SqlDatabaseOperations.SqlDatabaseActionsDefinition sqlDatabaseOperations;
    private SqlServerDnsAliasOperations.SqlServerDnsAliasActionsDefinition sqlServerDnsAliasOperations;
    private SqlFailoverGroupOperations.SqlFailoverGroupActionsDefinition sqlFailoverGroupOperations;
    private SqlServerKeyOperations.SqlServerKeyActionsDefinition sqlServerKeyOperations;
    private SqlServerSecurityAlertPolicyOperationsImpl sqlServerSecurityAlertPolicyOperations;
    private SqlEncryptionProtectorOperations.SqlEncryptionProtectorActionsDefinition sqlEncryptionProtectorsOperations;

    protected SqlServerImpl(String name, ServerInner innerObject, SqlServerManager manager) {
        super(name, (Resource)innerObject, (Manager)manager);
    }

    protected Mono<ServerInner> getInnerAsync() {
        return ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getServers().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Mono<SqlServer> createResourceAsync() {
        return ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getServers().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ServerInner)((Object)this.innerModel())).map(serverInner -> {
            this.setInner(serverInner);
            return this;
        });
    }

    public void beforeGroupCreateOrUpdate() {
        if (this.isInCreateMode()) {
            if (this.allowAzureServicesAccess) {
                this.sqlFirewallRules.defineInlineFirewallRule("AllowAllWindowsAzureIps").withStartIpAddress("0.0.0.0").withEndIpAddress("0.0.0.0");
            }
            if (this.sqlADAdminCreator != null) {
                this.addPostRunDependent(this.sqlADAdminCreator);
            }
        }
        if (this.sqlElasticPools != null && this.sqlDatabases != null) {
            List<SqlDatabaseImpl> dbToBeRemoved = this.sqlDatabases.getChildren(ExternalChildResourceImpl.PendingOperation.ToBeRemoved);
            List<SqlElasticPoolImpl> epToBeRemoved = this.sqlElasticPools.getChildren(ExternalChildResourceImpl.PendingOperation.ToBeRemoved);
            for (SqlElasticPoolImpl epItem : epToBeRemoved) {
                for (SqlDatabaseImpl dbItem : dbToBeRemoved) {
                    epItem.addParentDependency((TaskGroup.HasTaskGroup)dbItem);
                }
            }
            List<SqlDatabaseImpl> dbToBeCreated = this.sqlDatabases.getChildren(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
            List<SqlElasticPoolImpl> epToBeCreated = this.sqlElasticPools.getChildren(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
            for (SqlElasticPoolImpl epItem : epToBeCreated) {
                for (SqlDatabaseImpl dbItem : dbToBeCreated) {
                    if (dbItem.elasticPoolId() == null || !ResourceUtils.nameFromResourceId((String)dbItem.elasticPoolId()).equals(epItem.name())) continue;
                    dbItem.addParentDependency((TaskGroup.HasTaskGroup)epItem);
                }
            }
        }
    }

    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        this.sqlADAdminCreator = null;
        this.sqlFirewallRules.clear();
        this.sqlElasticPools.clear();
        this.sqlDatabases.clear();
        return Mono.empty();
    }

    @Override
    public String fullyQualifiedDomainName() {
        return ((ServerInner)((Object)this.innerModel())).fullyQualifiedDomainName();
    }

    @Override
    public String administratorLogin() {
        return ((ServerInner)((Object)this.innerModel())).administratorLogin();
    }

    @Override
    public String kind() {
        return ((ServerInner)((Object)this.innerModel())).kind();
    }

    @Override
    public String state() {
        return ((ServerInner)((Object)this.innerModel())).state();
    }

    @Override
    public boolean isManagedServiceIdentityEnabled() {
        return ((ServerInner)((Object)this.innerModel())).identity() != null && ((ServerInner)((Object)this.innerModel())).identity().type().equals((Object)IdentityType.SYSTEM_ASSIGNED);
    }

    @Override
    public String systemAssignedManagedServiceIdentityTenantId() {
        return ((ServerInner)((Object)this.innerModel())).identity() != null ? ((ServerInner)((Object)this.innerModel())).identity().tenantId().toString() : null;
    }

    @Override
    public String systemAssignedManagedServiceIdentityPrincipalId() {
        return ((ServerInner)((Object)this.innerModel())).identity() != null ? ((ServerInner)((Object)this.innerModel())).identity().principalId().toString() : null;
    }

    @Override
    public IdentityType managedServiceIdentityType() {
        return ((ServerInner)((Object)this.innerModel())).identity() != null ? ((ServerInner)((Object)this.innerModel())).identity().type() : null;
    }

    @Override
    public List<ServerMetric> listUsageMetrics() {
        ArrayList<ServerMetricImpl> serverMetrics = new ArrayList<ServerMetricImpl>();
        PagedIterable<ServerUsageInner> serverUsageInners = ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getServerUsages().listByServer(this.resourceGroupName(), this.name());
        for (ServerUsageInner serverUsageInner : serverUsageInners) {
            serverMetrics.add(new ServerMetricImpl(serverUsageInner));
        }
        return Collections.unmodifiableList(serverMetrics);
    }

    @Override
    public List<ServiceObjective> listServiceObjectives() {
        ArrayList<ServiceObjectiveImpl> serviceObjectives = new ArrayList<ServiceObjectiveImpl>();
        PagedIterable<ServiceObjectiveInner> serviceObjectiveInners = ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getServiceObjectives().listByServer(this.resourceGroupName(), this.name());
        for (ServiceObjectiveInner inner : serviceObjectiveInners) {
            serviceObjectives.add(new ServiceObjectiveImpl(inner, this));
        }
        return Collections.unmodifiableList(serviceObjectives);
    }

    @Override
    public ServiceObjective getServiceObjective(String serviceObjectiveName) {
        ServiceObjectiveInner inner = ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getServiceObjectives().get(this.resourceGroupName(), this.name(), serviceObjectiveName);
        return inner != null ? new ServiceObjectiveImpl(inner, this) : null;
    }

    @Override
    public Map<String, RecommendedElasticPool> listRecommendedElasticPools() {
        HashMap<String, RecommendedElasticPoolImpl> recommendedElasticPoolMap = new HashMap<String, RecommendedElasticPoolImpl>();
        PagedIterable<RecommendedElasticPoolInner> recommendedElasticPoolInners = ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getRecommendedElasticPools().listByServer(this.resourceGroupName(), this.name());
        for (RecommendedElasticPoolInner inner : recommendedElasticPoolInners) {
            recommendedElasticPoolMap.put(inner.name(), new RecommendedElasticPoolImpl(inner, this));
        }
        return Collections.unmodifiableMap(recommendedElasticPoolMap);
    }

    @Override
    public List<SqlRestorableDroppedDatabase> listRestorableDroppedDatabases() {
        ArrayList<SqlRestorableDroppedDatabaseImpl> sqlRestorableDroppedDatabases = new ArrayList<SqlRestorableDroppedDatabaseImpl>();
        PagedIterable<RestorableDroppedDatabaseInner> restorableDroppedDatabasesInners = ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getRestorableDroppedDatabases().listByServer(this.resourceGroupName(), this.name());
        for (RestorableDroppedDatabaseInner restorableDroppedDatabaseInner : restorableDroppedDatabasesInners) {
            sqlRestorableDroppedDatabases.add(new SqlRestorableDroppedDatabaseImpl(this.resourceGroupName(), this.name(), restorableDroppedDatabaseInner, (SqlServerManager)this.manager()));
        }
        return Collections.unmodifiableList(sqlRestorableDroppedDatabases);
    }

    @Override
    public PagedFlux<SqlRestorableDroppedDatabase> listRestorableDroppedDatabasesAsync() {
        SqlServerImpl self = this;
        return ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getRestorableDroppedDatabases().listByServerAsync(this.resourceGroupName(), this.name()).mapPage(restorableDroppedDatabaseInner -> new SqlRestorableDroppedDatabaseImpl(self.resourceGroupName(), self.name(), (RestorableDroppedDatabaseInner)((Object)restorableDroppedDatabaseInner), (SqlServerManager)self.manager()));
    }

    @Override
    public String version() {
        return ((ServerInner)((Object)this.innerModel())).version();
    }

    @Override
    public SqlFirewallRule enableAccessFromAzureServices() {
        SqlFirewallRule firewallRule;
        block3: {
            firewallRule = null;
            try {
                firewallRule = (SqlFirewallRule)((SqlServerManager)this.manager()).sqlServers().firewallRules().getBySqlServer(this.resourceGroupName(), this.name(), "AllowAllWindowsAzureIps");
            }
            catch (ManagementException e) {
                if (e.getResponse().getStatusCode() == 404) break block3;
                throw this.logger.logExceptionAsError((RuntimeException)((Object)e));
            }
        }
        if (firewallRule == null) {
            firewallRule = (SqlFirewallRule)((SqlFirewallRuleOperations.DefinitionStages.WithSqlServer)((SqlServerManager)this.manager()).sqlServers().firewallRules().define("AllowAllWindowsAzureIps")).withExistingSqlServer(this.resourceGroupName(), this.name()).withIpAddress("0.0.0.0").create();
        }
        return firewallRule;
    }

    @Override
    public void removeAccessFromAzureServices() {
        SqlFirewallRule firewallRule = (SqlFirewallRule)((SqlServerManager)this.manager()).sqlServers().firewallRules().getBySqlServer(this.resourceGroupName(), this.name(), "AllowAllWindowsAzureIps");
        if (firewallRule != null) {
            ((SqlServerManager)this.manager()).sqlServers().firewallRules().deleteBySqlServer(this.resourceGroupName(), this.name(), "AllowAllWindowsAzureIps");
        }
    }

    @Override
    public SqlActiveDirectoryAdministratorImpl setActiveDirectoryAdministrator(String userLogin, String objectId) {
        ServerAzureADAdministratorInner serverAzureADAdministratorInner = new ServerAzureADAdministratorInner().withLogin(userLogin).withSid(UUID.fromString(objectId)).withTenantId(UUID.fromString(((SqlServerManager)this.manager()).tenantId()));
        return new SqlActiveDirectoryAdministratorImpl(((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getServerAzureADAdministrators().createOrUpdate(this.resourceGroupName(), this.name(), AdministratorName.ACTIVE_DIRECTORY, serverAzureADAdministratorInner));
    }

    @Override
    public SqlActiveDirectoryAdministratorImpl getActiveDirectoryAdministrator() {
        ServerAzureADAdministratorInner serverAzureADAdministratorInner = ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getServerAzureADAdministrators().get(this.resourceGroupName(), this.name(), AdministratorName.ACTIVE_DIRECTORY);
        return serverAzureADAdministratorInner != null ? new SqlActiveDirectoryAdministratorImpl(serverAzureADAdministratorInner) : null;
    }

    @Override
    public void removeActiveDirectoryAdministrator() {
        ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getServerAzureADAdministrators().delete(this.resourceGroupName(), this.name(), AdministratorName.ACTIVE_DIRECTORY);
    }

    @Override
    public SqlServerAutomaticTuning getServerAutomaticTuning() {
        ServerAutomaticTuningInner serverAutomaticTuningInner = ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getServerAutomaticTunings().get(this.resourceGroupName(), this.name());
        return serverAutomaticTuningInner != null ? new SqlServerAutomaticTuningImpl(this, serverAutomaticTuningInner) : null;
    }

    @Override
    public SqlFirewallRuleOperations.SqlFirewallRuleActionsDefinition firewallRules() {
        if (this.sqlFirewallRuleOperations == null) {
            this.sqlFirewallRuleOperations = new SqlFirewallRuleOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlFirewallRuleOperations;
    }

    @Override
    public SqlVirtualNetworkRuleOperations.SqlVirtualNetworkRuleActionsDefinition virtualNetworkRules() {
        if (this.sqlVirtualNetworkRuleOperations == null) {
            this.sqlVirtualNetworkRuleOperations = new SqlVirtualNetworkRuleOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlVirtualNetworkRuleOperations;
    }

    @Override
    public SqlServerImpl withAdministratorLogin(String administratorLogin) {
        ((ServerInner)((Object)this.innerModel())).withAdministratorLogin(administratorLogin);
        return this;
    }

    @Override
    public SqlServerImpl withAdministratorPassword(String administratorLoginPassword) {
        ((ServerInner)((Object)this.innerModel())).withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    @Override
    public SqlServerImpl withoutAccessFromAzureServices() {
        this.allowAzureServicesAccess = false;
        return this;
    }

    @Override
    public SqlServer.DefinitionStages.WithCreate withActiveDirectoryAdministrator(String userLogin, String objectId) {
        SqlServerImpl self = this;
        this.sqlADAdminCreator = context -> {
            ServerAzureADAdministratorInner serverAzureADAdministratorInner = new ServerAzureADAdministratorInner().withLogin(userLogin).withSid(UUID.fromString(objectId)).withTenantId(UUID.fromString(((SqlServerManager)self.manager()).tenantId()));
            return ((SqlManagementClient)((SqlServerManager)self.manager()).serviceClient()).getServerAzureADAdministrators().createOrUpdateAsync(self.resourceGroupName(), self.name(), AdministratorName.ACTIVE_DIRECTORY, serverAzureADAdministratorInner).flatMap(serverAzureADAdministratorInner1 -> context.voidMono());
        };
        return this;
    }

    public SqlFirewallRuleImpl defineFirewallRule(String name) {
        return this.sqlFirewallRules.defineInlineFirewallRule(name);
    }

    @Override
    public SqlServerImpl withoutFirewallRule(String firewallRuleName) {
        this.sqlFirewallRules.removeInlineFirewallRule(firewallRuleName);
        return this;
    }

    public SqlVirtualNetworkRule.DefinitionStages.Blank<SqlServer.DefinitionStages.WithCreate> defineVirtualNetworkRule(String virtualNetworkRuleName) {
        return this.sqlVirtualNetworkRules.defineInlineVirtualNetworkRule(virtualNetworkRuleName);
    }

    @Override
    public SqlElasticPoolOperations.SqlElasticPoolActionsDefinition elasticPools() {
        if (this.sqlElasticPoolOperations == null) {
            this.sqlElasticPoolOperations = new SqlElasticPoolOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlElasticPoolOperations;
    }

    @Override
    public SqlDatabaseOperations.SqlDatabaseActionsDefinition databases() {
        if (this.sqlDatabaseOperations == null) {
            this.sqlDatabaseOperations = new SqlDatabaseOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlDatabaseOperations;
    }

    @Override
    public SqlServerDnsAliasOperations.SqlServerDnsAliasActionsDefinition dnsAliases() {
        if (this.sqlServerDnsAliasOperations == null) {
            this.sqlServerDnsAliasOperations = new SqlServerDnsAliasOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlServerDnsAliasOperations;
    }

    @Override
    public SqlFailoverGroupOperations.SqlFailoverGroupActionsDefinition failoverGroups() {
        if (this.sqlFailoverGroupOperations == null) {
            this.sqlFailoverGroupOperations = new SqlFailoverGroupOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlFailoverGroupOperations;
    }

    @Override
    public SqlServerKeyOperations.SqlServerKeyActionsDefinition serverKeys() {
        if (this.sqlServerKeyOperations == null) {
            this.sqlServerKeyOperations = new SqlServerKeyOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlServerKeyOperations;
    }

    @Override
    public SqlEncryptionProtectorOperations.SqlEncryptionProtectorActionsDefinition encryptionProtectors() {
        if (this.sqlEncryptionProtectorsOperations == null) {
            this.sqlEncryptionProtectorsOperations = new SqlEncryptionProtectorOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlEncryptionProtectorsOperations;
    }

    @Override
    public SqlServerSecurityAlertPolicyOperations.SqlServerSecurityAlertPolicyActionsDefinition serverSecurityAlertPolicies() {
        if (this.sqlServerSecurityAlertPolicyOperations == null) {
            this.sqlServerSecurityAlertPolicyOperations = new SqlServerSecurityAlertPolicyOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlServerSecurityAlertPolicyOperations;
    }

    public SqlElasticPoolImpl defineElasticPool(String name) {
        return this.sqlElasticPools.defineInlineElasticPool(name);
    }

    @Override
    public SqlServerImpl withoutElasticPool(String elasticPoolName) {
        this.sqlElasticPools.removeInlineElasticPool(elasticPoolName);
        return this;
    }

    public SqlDatabaseImpl defineDatabase(String name) {
        return this.sqlDatabases.defineInlineDatabase(name);
    }

    @Override
    public SqlServerImpl withoutDatabase(String databaseName) {
        this.sqlDatabases.removeInlineDatabase(databaseName);
        return this;
    }

    @Override
    public SqlServerImpl withSystemAssignedManagedServiceIdentity() {
        ((ServerInner)((Object)this.innerModel())).withIdentity(new ResourceIdentity().withType(IdentityType.SYSTEM_ASSIGNED));
        return this;
    }
}

