/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.SyncDatabaseIdPropertiesInner;
import com.azure.resourcemanager.sql.fluent.models.SyncGroupInner;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseImpl;
import com.azure.resourcemanager.sql.implementation.SqlSyncGroupImpl;
import com.azure.resourcemanager.sql.models.SqlSyncGroup;
import com.azure.resourcemanager.sql.models.SqlSyncGroupOperations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlSyncGroupOperationsImpl
implements SqlSyncGroupOperations,
SqlSyncGroupOperations.SqlSyncGroupActionsDefinition {
    protected SqlServerManager sqlServerManager;
    protected SqlDatabaseImpl sqlDatabase;

    SqlSyncGroupOperationsImpl(SqlDatabaseImpl parent, SqlServerManager sqlServerManager) {
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlDatabase = parent;
        this.sqlServerManager = sqlServerManager;
    }

    SqlSyncGroupOperationsImpl(SqlServerManager sqlServerManager) {
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
    }

    @Override
    public SqlSyncGroup getBySqlServer(String resourceGroupName, String sqlServerName, String databaseName, String name) {
        SyncGroupInner syncGroupInner = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().get(resourceGroupName, sqlServerName, databaseName, name);
        return syncGroupInner != null ? new SqlSyncGroupImpl(resourceGroupName, sqlServerName, databaseName, name, syncGroupInner, this.sqlServerManager) : null;
    }

    @Override
    public Mono<SqlSyncGroup> getBySqlServerAsync(String resourceGroupName, String sqlServerName, String databaseName, String name) {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().getAsync(resourceGroupName, sqlServerName, databaseName, name).map(syncGroupInner -> new SqlSyncGroupImpl(resourceGroupName, sqlServerName, databaseName, name, (SyncGroupInner)((Object)syncGroupInner), this.sqlServerManager));
    }

    @Override
    public PagedIterable<String> listSyncDatabaseIds(String locationName) {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().listSyncDatabaseIds(locationName).mapPage(SyncDatabaseIdPropertiesInner::id);
    }

    @Override
    public PagedFlux<String> listSyncDatabaseIdsAsync(String locationName) {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().listSyncDatabaseIdsAsync(locationName).mapPage(SyncDatabaseIdPropertiesInner::id);
    }

    @Override
    public PagedIterable<String> listSyncDatabaseIds(Region region) {
        return this.listSyncDatabaseIds(region.name());
    }

    @Override
    public PagedFlux<String> listSyncDatabaseIdsAsync(Region region) {
        return this.listSyncDatabaseIdsAsync(region.name());
    }

    @Override
    public SqlSyncGroupImpl define(String name) {
        SqlSyncGroupImpl result = new SqlSyncGroupImpl(name, new SyncGroupInner(), this.sqlServerManager);
        result.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        return this.sqlDatabase != null ? result.withExistingSqlDatabase(this.sqlDatabase) : result;
    }

    @Override
    public SqlSyncGroup get(String name) {
        if (this.sqlDatabase == null) {
            return null;
        }
        return this.getBySqlServer(this.sqlDatabase.resourceGroupName(), this.sqlDatabase.sqlServerName(), this.sqlDatabase.name(), name);
    }

    @Override
    public Mono<SqlSyncGroup> getAsync(String name) {
        if (this.sqlDatabase == null) {
            return null;
        }
        return this.getBySqlServerAsync(this.sqlDatabase.resourceGroupName(), this.sqlDatabase.sqlServerName(), this.sqlDatabase.name(), name);
    }

    @Override
    public SqlSyncGroup getById(String id) {
        Objects.requireNonNull(id);
        try {
            ResourceId resourceId = ResourceId.fromString((String)id);
            return this.getBySqlServer(resourceId.resourceGroupName(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public Mono<SqlSyncGroup> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        try {
            ResourceId resourceId = ResourceId.fromString((String)id);
            return this.getBySqlServerAsync(resourceId.resourceGroupName(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public void delete(String name) {
        if (this.sqlDatabase == null) {
            return;
        }
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().delete(this.sqlDatabase.resourceGroupName(), this.sqlDatabase.sqlServerName(), this.sqlDatabase.name(), name);
    }

    @Override
    public Mono<Void> deleteAsync(String name) {
        if (this.sqlDatabase == null) {
            return null;
        }
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().deleteAsync(this.sqlDatabase.resourceGroupName(), this.sqlDatabase.sqlServerName(), this.sqlDatabase.name(), name);
    }

    @Override
    public void deleteById(String id) {
        Objects.requireNonNull(id);
        try {
            ResourceId resourceId = ResourceId.fromString((String)id);
            ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().delete(resourceId.resourceGroupName(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        try {
            ResourceId resourceId = ResourceId.fromString((String)id);
            return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().deleteAsync(resourceId.resourceGroupName(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public List<SqlSyncGroup> list() {
        ArrayList<SqlSyncGroupImpl> sqlSyncGroups = new ArrayList<SqlSyncGroupImpl>();
        if (this.sqlDatabase != null) {
            PagedIterable<SyncGroupInner> syncGroupInners = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().listByDatabase(this.sqlDatabase.resourceGroupName(), this.sqlDatabase.sqlServerName(), this.sqlDatabase.name());
            for (SyncGroupInner groupInner : syncGroupInners) {
                sqlSyncGroups.add(new SqlSyncGroupImpl(groupInner.name(), this.sqlDatabase, groupInner, this.sqlServerManager));
            }
        }
        return Collections.unmodifiableList(sqlSyncGroups);
    }

    @Override
    public PagedFlux<SqlSyncGroup> listAsync() {
        SqlSyncGroupOperationsImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().listByDatabaseAsync(this.sqlDatabase.resourceGroupName(), this.sqlDatabase.sqlServerName(), this.sqlDatabase.name()).mapPage(syncGroupInner -> new SqlSyncGroupImpl(syncGroupInner.name(), self.sqlDatabase, (SyncGroupInner)((Object)syncGroupInner), self.sqlServerManager));
    }
}

