/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.CatalogCollationType;
import com.azure.resourcemanager.sql.models.CreateMode;
import com.azure.resourcemanager.sql.models.DatabaseLicenseType;
import com.azure.resourcemanager.sql.models.DatabaseReadScale;
import com.azure.resourcemanager.sql.models.DatabaseStatus;
import com.azure.resourcemanager.sql.models.SampleName;
import com.azure.resourcemanager.sql.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

@JsonFlatten
public class DatabaseUpdate {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DatabaseUpdate.class);
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="properties.createMode")
    private CreateMode createMode;
    @JsonProperty(value="properties.collation")
    private String collation;
    @JsonProperty(value="properties.maxSizeBytes")
    private Long maxSizeBytes;
    @JsonProperty(value="properties.sampleName")
    private SampleName sampleName;
    @JsonProperty(value="properties.elasticPoolId")
    private String elasticPoolId;
    @JsonProperty(value="properties.sourceDatabaseId")
    private String sourceDatabaseId;
    @JsonProperty(value="properties.status", access=JsonProperty.Access.WRITE_ONLY)
    private DatabaseStatus status;
    @JsonProperty(value="properties.databaseId", access=JsonProperty.Access.WRITE_ONLY)
    private UUID databaseId;
    @JsonProperty(value="properties.creationDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationDate;
    @JsonProperty(value="properties.currentServiceObjectiveName", access=JsonProperty.Access.WRITE_ONLY)
    private String currentServiceObjectiveName;
    @JsonProperty(value="properties.requestedServiceObjectiveName", access=JsonProperty.Access.WRITE_ONLY)
    private String requestedServiceObjectiveName;
    @JsonProperty(value="properties.defaultSecondaryLocation", access=JsonProperty.Access.WRITE_ONLY)
    private String defaultSecondaryLocation;
    @JsonProperty(value="properties.failoverGroupId", access=JsonProperty.Access.WRITE_ONLY)
    private String failoverGroupId;
    @JsonProperty(value="properties.restorePointInTime")
    private OffsetDateTime restorePointInTime;
    @JsonProperty(value="properties.sourceDatabaseDeletionDate")
    private OffsetDateTime sourceDatabaseDeletionDate;
    @JsonProperty(value="properties.recoveryServicesRecoveryPointId")
    private String recoveryServicesRecoveryPointId;
    @JsonProperty(value="properties.longTermRetentionBackupResourceId")
    private String longTermRetentionBackupResourceId;
    @JsonProperty(value="properties.recoverableDatabaseId")
    private String recoverableDatabaseId;
    @JsonProperty(value="properties.restorableDroppedDatabaseId")
    private String restorableDroppedDatabaseId;
    @JsonProperty(value="properties.catalogCollation")
    private CatalogCollationType catalogCollation;
    @JsonProperty(value="properties.zoneRedundant")
    private Boolean zoneRedundant;
    @JsonProperty(value="properties.licenseType")
    private DatabaseLicenseType licenseType;
    @JsonProperty(value="properties.maxLogSizeBytes", access=JsonProperty.Access.WRITE_ONLY)
    private Long maxLogSizeBytes;
    @JsonProperty(value="properties.earliestRestoreDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime earliestRestoreDate;
    @JsonProperty(value="properties.readScale")
    private DatabaseReadScale readScale;
    @JsonProperty(value="properties.readReplicaCount")
    private Integer readReplicaCount;
    @JsonProperty(value="properties.currentSku", access=JsonProperty.Access.WRITE_ONLY)
    private Sku currentSku;
    @JsonProperty(value="properties.autoPauseDelay")
    private Integer autoPauseDelay;
    @JsonProperty(value="properties.minCapacity")
    private Double minCapacity;
    @JsonProperty(value="properties.pausedDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime pausedDate;
    @JsonProperty(value="properties.resumedDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime resumedDate;

    public Sku sku() {
        return this.sku;
    }

    public DatabaseUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public DatabaseUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public DatabaseUpdate withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public String collation() {
        return this.collation;
    }

    public DatabaseUpdate withCollation(String collation) {
        this.collation = collation;
        return this;
    }

    public Long maxSizeBytes() {
        return this.maxSizeBytes;
    }

    public DatabaseUpdate withMaxSizeBytes(Long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    public SampleName sampleName() {
        return this.sampleName;
    }

    public DatabaseUpdate withSampleName(SampleName sampleName) {
        this.sampleName = sampleName;
        return this;
    }

    public String elasticPoolId() {
        return this.elasticPoolId;
    }

    public DatabaseUpdate withElasticPoolId(String elasticPoolId) {
        this.elasticPoolId = elasticPoolId;
        return this;
    }

    public String sourceDatabaseId() {
        return this.sourceDatabaseId;
    }

    public DatabaseUpdate withSourceDatabaseId(String sourceDatabaseId) {
        this.sourceDatabaseId = sourceDatabaseId;
        return this;
    }

    public DatabaseStatus status() {
        return this.status;
    }

    public UUID databaseId() {
        return this.databaseId;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public String currentServiceObjectiveName() {
        return this.currentServiceObjectiveName;
    }

    public String requestedServiceObjectiveName() {
        return this.requestedServiceObjectiveName;
    }

    public String defaultSecondaryLocation() {
        return this.defaultSecondaryLocation;
    }

    public String failoverGroupId() {
        return this.failoverGroupId;
    }

    public OffsetDateTime restorePointInTime() {
        return this.restorePointInTime;
    }

    public DatabaseUpdate withRestorePointInTime(OffsetDateTime restorePointInTime) {
        this.restorePointInTime = restorePointInTime;
        return this;
    }

    public OffsetDateTime sourceDatabaseDeletionDate() {
        return this.sourceDatabaseDeletionDate;
    }

    public DatabaseUpdate withSourceDatabaseDeletionDate(OffsetDateTime sourceDatabaseDeletionDate) {
        this.sourceDatabaseDeletionDate = sourceDatabaseDeletionDate;
        return this;
    }

    public String recoveryServicesRecoveryPointId() {
        return this.recoveryServicesRecoveryPointId;
    }

    public DatabaseUpdate withRecoveryServicesRecoveryPointId(String recoveryServicesRecoveryPointId) {
        this.recoveryServicesRecoveryPointId = recoveryServicesRecoveryPointId;
        return this;
    }

    public String longTermRetentionBackupResourceId() {
        return this.longTermRetentionBackupResourceId;
    }

    public DatabaseUpdate withLongTermRetentionBackupResourceId(String longTermRetentionBackupResourceId) {
        this.longTermRetentionBackupResourceId = longTermRetentionBackupResourceId;
        return this;
    }

    public String recoverableDatabaseId() {
        return this.recoverableDatabaseId;
    }

    public DatabaseUpdate withRecoverableDatabaseId(String recoverableDatabaseId) {
        this.recoverableDatabaseId = recoverableDatabaseId;
        return this;
    }

    public String restorableDroppedDatabaseId() {
        return this.restorableDroppedDatabaseId;
    }

    public DatabaseUpdate withRestorableDroppedDatabaseId(String restorableDroppedDatabaseId) {
        this.restorableDroppedDatabaseId = restorableDroppedDatabaseId;
        return this;
    }

    public CatalogCollationType catalogCollation() {
        return this.catalogCollation;
    }

    public DatabaseUpdate withCatalogCollation(CatalogCollationType catalogCollation) {
        this.catalogCollation = catalogCollation;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public DatabaseUpdate withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public DatabaseLicenseType licenseType() {
        return this.licenseType;
    }

    public DatabaseUpdate withLicenseType(DatabaseLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public Long maxLogSizeBytes() {
        return this.maxLogSizeBytes;
    }

    public OffsetDateTime earliestRestoreDate() {
        return this.earliestRestoreDate;
    }

    public DatabaseReadScale readScale() {
        return this.readScale;
    }

    public DatabaseUpdate withReadScale(DatabaseReadScale readScale) {
        this.readScale = readScale;
        return this;
    }

    public Integer readReplicaCount() {
        return this.readReplicaCount;
    }

    public DatabaseUpdate withReadReplicaCount(Integer readReplicaCount) {
        this.readReplicaCount = readReplicaCount;
        return this;
    }

    public Sku currentSku() {
        return this.currentSku;
    }

    public Integer autoPauseDelay() {
        return this.autoPauseDelay;
    }

    public DatabaseUpdate withAutoPauseDelay(Integer autoPauseDelay) {
        this.autoPauseDelay = autoPauseDelay;
        return this;
    }

    public Double minCapacity() {
        return this.minCapacity;
    }

    public DatabaseUpdate withMinCapacity(Double minCapacity) {
        this.minCapacity = minCapacity;
        return this;
    }

    public OffsetDateTime pausedDate() {
        return this.pausedDate;
    }

    public OffsetDateTime resumedDate() {
        return this.resumedDate;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.currentSku() != null) {
            this.currentSku().validate();
        }
    }
}

