/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.fluent.models.RecommendedElasticPoolMetricInner;
import com.azure.resourcemanager.sql.models.ElasticPoolEdition;
import com.azure.resourcemanager.sql.models.TrackedResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

@JsonFlatten
public class RecommendedElasticPoolInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RecommendedElasticPoolInner.class);
    @JsonProperty(value="properties.databaseEdition", access=JsonProperty.Access.WRITE_ONLY)
    private ElasticPoolEdition databaseEdition;
    @JsonProperty(value="properties.dtu")
    private Double dtu;
    @JsonProperty(value="properties.databaseDtuMin")
    private Double databaseDtuMin;
    @JsonProperty(value="properties.databaseDtuMax")
    private Double databaseDtuMax;
    @JsonProperty(value="properties.storageMB")
    private Double storageMB;
    @JsonProperty(value="properties.observationPeriodStart", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime observationPeriodStart;
    @JsonProperty(value="properties.observationPeriodEnd", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime observationPeriodEnd;
    @JsonProperty(value="properties.maxObservedDtu", access=JsonProperty.Access.WRITE_ONLY)
    private Double maxObservedDtu;
    @JsonProperty(value="properties.maxObservedStorageMB", access=JsonProperty.Access.WRITE_ONLY)
    private Double maxObservedStorageMB;
    @JsonProperty(value="properties.databases", access=JsonProperty.Access.WRITE_ONLY)
    private List<TrackedResource> databases;
    @JsonProperty(value="properties.metrics", access=JsonProperty.Access.WRITE_ONLY)
    private List<RecommendedElasticPoolMetricInner> metrics;

    public ElasticPoolEdition databaseEdition() {
        return this.databaseEdition;
    }

    public Double dtu() {
        return this.dtu;
    }

    public RecommendedElasticPoolInner withDtu(Double dtu) {
        this.dtu = dtu;
        return this;
    }

    public Double databaseDtuMin() {
        return this.databaseDtuMin;
    }

    public RecommendedElasticPoolInner withDatabaseDtuMin(Double databaseDtuMin) {
        this.databaseDtuMin = databaseDtuMin;
        return this;
    }

    public Double databaseDtuMax() {
        return this.databaseDtuMax;
    }

    public RecommendedElasticPoolInner withDatabaseDtuMax(Double databaseDtuMax) {
        this.databaseDtuMax = databaseDtuMax;
        return this;
    }

    public Double storageMB() {
        return this.storageMB;
    }

    public RecommendedElasticPoolInner withStorageMB(Double storageMB) {
        this.storageMB = storageMB;
        return this;
    }

    public OffsetDateTime observationPeriodStart() {
        return this.observationPeriodStart;
    }

    public OffsetDateTime observationPeriodEnd() {
        return this.observationPeriodEnd;
    }

    public Double maxObservedDtu() {
        return this.maxObservedDtu;
    }

    public Double maxObservedStorageMB() {
        return this.maxObservedStorageMB;
    }

    public List<TrackedResource> databases() {
        return this.databases;
    }

    public List<RecommendedElasticPoolMetricInner> metrics() {
        return this.metrics;
    }

    public void validate() {
        if (this.databases() != null) {
            this.databases().forEach(e -> e.validate());
        }
        if (this.metrics() != null) {
            this.metrics().forEach(e -> e.validate());
        }
    }
}

