/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.SyncConflictResolutionPolicy;
import com.azure.resourcemanager.sql.models.SyncGroupSchema;
import com.azure.resourcemanager.sql.models.SyncGroupState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

@JsonFlatten
public class SyncGroupInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SyncGroupInner.class);
    @JsonProperty(value="properties.interval")
    private Integer interval;
    @JsonProperty(value="properties.lastSyncTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastSyncTime;
    @JsonProperty(value="properties.conflictResolutionPolicy")
    private SyncConflictResolutionPolicy conflictResolutionPolicy;
    @JsonProperty(value="properties.syncDatabaseId")
    private String syncDatabaseId;
    @JsonProperty(value="properties.hubDatabaseUserName")
    private String hubDatabaseUsername;
    @JsonProperty(value="properties.hubDatabasePassword")
    private String hubDatabasePassword;
    @JsonProperty(value="properties.syncState", access=JsonProperty.Access.WRITE_ONLY)
    private SyncGroupState syncState;
    @JsonProperty(value="properties.schema")
    private SyncGroupSchema schema;

    public Integer interval() {
        return this.interval;
    }

    public SyncGroupInner withInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    public OffsetDateTime lastSyncTime() {
        return this.lastSyncTime;
    }

    public SyncConflictResolutionPolicy conflictResolutionPolicy() {
        return this.conflictResolutionPolicy;
    }

    public SyncGroupInner withConflictResolutionPolicy(SyncConflictResolutionPolicy conflictResolutionPolicy) {
        this.conflictResolutionPolicy = conflictResolutionPolicy;
        return this;
    }

    public String syncDatabaseId() {
        return this.syncDatabaseId;
    }

    public SyncGroupInner withSyncDatabaseId(String syncDatabaseId) {
        this.syncDatabaseId = syncDatabaseId;
        return this;
    }

    public String hubDatabaseUsername() {
        return this.hubDatabaseUsername;
    }

    public SyncGroupInner withHubDatabaseUsername(String hubDatabaseUsername) {
        this.hubDatabaseUsername = hubDatabaseUsername;
        return this;
    }

    public String hubDatabasePassword() {
        return this.hubDatabasePassword;
    }

    public SyncGroupInner withHubDatabasePassword(String hubDatabasePassword) {
        this.hubDatabasePassword = hubDatabasePassword;
        return this;
    }

    public SyncGroupState syncState() {
        return this.syncState;
    }

    public SyncGroupSchema schema() {
        return this.schema;
    }

    public SyncGroupInner withSchema(SyncGroupSchema schema) {
        this.schema = schema;
        return this;
    }

    public void validate() {
        if (this.schema() != null) {
            this.schema().validate();
        }
    }
}

