/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.resourcemanager.sql.models.AlwaysEncryptedEnclaveType;
import com.azure.resourcemanager.sql.models.AvailabilityZoneType;
import com.azure.resourcemanager.sql.models.ElasticPoolLicenseType;
import com.azure.resourcemanager.sql.models.ElasticPoolPerDatabaseSettings;
import com.azure.resourcemanager.sql.models.ElasticPoolState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class ElasticPoolProperties {
    @JsonProperty(value="state", access=JsonProperty.Access.WRITE_ONLY)
    private ElasticPoolState state;
    @JsonProperty(value="creationDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationDate;
    @JsonProperty(value="maxSizeBytes")
    private Long maxSizeBytes;
    @JsonProperty(value="minCapacity")
    private Double minCapacity;
    @JsonProperty(value="perDatabaseSettings")
    private ElasticPoolPerDatabaseSettings perDatabaseSettings;
    @JsonProperty(value="zoneRedundant")
    private Boolean zoneRedundant;
    @JsonProperty(value="licenseType")
    private ElasticPoolLicenseType licenseType;
    @JsonProperty(value="maintenanceConfigurationId")
    private String maintenanceConfigurationId;
    @JsonProperty(value="highAvailabilityReplicaCount")
    private Integer highAvailabilityReplicaCount;
    @JsonProperty(value="preferredEnclaveType")
    private AlwaysEncryptedEnclaveType preferredEnclaveType;
    @JsonProperty(value="availabilityZone")
    private AvailabilityZoneType availabilityZone;

    public ElasticPoolState state() {
        return this.state;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public Long maxSizeBytes() {
        return this.maxSizeBytes;
    }

    public ElasticPoolProperties withMaxSizeBytes(Long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    public Double minCapacity() {
        return this.minCapacity;
    }

    public ElasticPoolProperties withMinCapacity(Double minCapacity) {
        this.minCapacity = minCapacity;
        return this;
    }

    public ElasticPoolPerDatabaseSettings perDatabaseSettings() {
        return this.perDatabaseSettings;
    }

    public ElasticPoolProperties withPerDatabaseSettings(ElasticPoolPerDatabaseSettings perDatabaseSettings) {
        this.perDatabaseSettings = perDatabaseSettings;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public ElasticPoolProperties withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public ElasticPoolLicenseType licenseType() {
        return this.licenseType;
    }

    public ElasticPoolProperties withLicenseType(ElasticPoolLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public String maintenanceConfigurationId() {
        return this.maintenanceConfigurationId;
    }

    public ElasticPoolProperties withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        this.maintenanceConfigurationId = maintenanceConfigurationId;
        return this;
    }

    public Integer highAvailabilityReplicaCount() {
        return this.highAvailabilityReplicaCount;
    }

    public ElasticPoolProperties withHighAvailabilityReplicaCount(Integer highAvailabilityReplicaCount) {
        this.highAvailabilityReplicaCount = highAvailabilityReplicaCount;
        return this;
    }

    public AlwaysEncryptedEnclaveType preferredEnclaveType() {
        return this.preferredEnclaveType;
    }

    public ElasticPoolProperties withPreferredEnclaveType(AlwaysEncryptedEnclaveType preferredEnclaveType) {
        this.preferredEnclaveType = preferredEnclaveType;
        return this;
    }

    public AvailabilityZoneType availabilityZone() {
        return this.availabilityZone;
    }

    public ElasticPoolProperties withAvailabilityZone(AvailabilityZoneType availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public void validate() {
        if (this.perDatabaseSettings() != null) {
            this.perDatabaseSettings().validate();
        }
    }
}

