/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.RecommendedActionErrorInfo;
import com.azure.resourcemanager.sql.models.RecommendedActionImpactRecord;
import com.azure.resourcemanager.sql.models.RecommendedActionImplementationInfo;
import com.azure.resourcemanager.sql.models.RecommendedActionInitiatedBy;
import com.azure.resourcemanager.sql.models.RecommendedActionMetricInfo;
import com.azure.resourcemanager.sql.models.RecommendedActionStateInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class RecommendedActionProperties {
    @JsonProperty(value="recommendationReason", access=JsonProperty.Access.WRITE_ONLY)
    private String recommendationReason;
    @JsonProperty(value="validSince", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime validSince;
    @JsonProperty(value="lastRefresh", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastRefresh;
    @JsonProperty(value="state", required=true)
    private RecommendedActionStateInfo state;
    @JsonProperty(value="isExecutableAction", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isExecutableAction;
    @JsonProperty(value="isRevertableAction", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isRevertableAction;
    @JsonProperty(value="isArchivedAction", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isArchivedAction;
    @JsonProperty(value="executeActionStartTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime executeActionStartTime;
    @JsonProperty(value="executeActionDuration", access=JsonProperty.Access.WRITE_ONLY)
    private String executeActionDuration;
    @JsonProperty(value="revertActionStartTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime revertActionStartTime;
    @JsonProperty(value="revertActionDuration", access=JsonProperty.Access.WRITE_ONLY)
    private String revertActionDuration;
    @JsonProperty(value="executeActionInitiatedBy", access=JsonProperty.Access.WRITE_ONLY)
    private RecommendedActionInitiatedBy executeActionInitiatedBy;
    @JsonProperty(value="executeActionInitiatedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime executeActionInitiatedTime;
    @JsonProperty(value="revertActionInitiatedBy", access=JsonProperty.Access.WRITE_ONLY)
    private RecommendedActionInitiatedBy revertActionInitiatedBy;
    @JsonProperty(value="revertActionInitiatedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime revertActionInitiatedTime;
    @JsonProperty(value="score", access=JsonProperty.Access.WRITE_ONLY)
    private Integer score;
    @JsonProperty(value="implementationDetails", access=JsonProperty.Access.WRITE_ONLY)
    private RecommendedActionImplementationInfo implementationDetails;
    @JsonProperty(value="errorDetails", access=JsonProperty.Access.WRITE_ONLY)
    private RecommendedActionErrorInfo errorDetails;
    @JsonProperty(value="estimatedImpact", access=JsonProperty.Access.WRITE_ONLY)
    private List<RecommendedActionImpactRecord> estimatedImpact;
    @JsonProperty(value="observedImpact", access=JsonProperty.Access.WRITE_ONLY)
    private List<RecommendedActionImpactRecord> observedImpact;
    @JsonProperty(value="timeSeries", access=JsonProperty.Access.WRITE_ONLY)
    private List<RecommendedActionMetricInfo> timeSeries;
    @JsonProperty(value="linkedObjects", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> linkedObjects;
    @JsonProperty(value="details", access=JsonProperty.Access.WRITE_ONLY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, Object> details;
    private static final ClientLogger LOGGER = new ClientLogger(RecommendedActionProperties.class);

    public String recommendationReason() {
        return this.recommendationReason;
    }

    public OffsetDateTime validSince() {
        return this.validSince;
    }

    public OffsetDateTime lastRefresh() {
        return this.lastRefresh;
    }

    public RecommendedActionStateInfo state() {
        return this.state;
    }

    public RecommendedActionProperties withState(RecommendedActionStateInfo state) {
        this.state = state;
        return this;
    }

    public Boolean isExecutableAction() {
        return this.isExecutableAction;
    }

    public Boolean isRevertableAction() {
        return this.isRevertableAction;
    }

    public Boolean isArchivedAction() {
        return this.isArchivedAction;
    }

    public OffsetDateTime executeActionStartTime() {
        return this.executeActionStartTime;
    }

    public String executeActionDuration() {
        return this.executeActionDuration;
    }

    public OffsetDateTime revertActionStartTime() {
        return this.revertActionStartTime;
    }

    public String revertActionDuration() {
        return this.revertActionDuration;
    }

    public RecommendedActionInitiatedBy executeActionInitiatedBy() {
        return this.executeActionInitiatedBy;
    }

    public OffsetDateTime executeActionInitiatedTime() {
        return this.executeActionInitiatedTime;
    }

    public RecommendedActionInitiatedBy revertActionInitiatedBy() {
        return this.revertActionInitiatedBy;
    }

    public OffsetDateTime revertActionInitiatedTime() {
        return this.revertActionInitiatedTime;
    }

    public Integer score() {
        return this.score;
    }

    public RecommendedActionImplementationInfo implementationDetails() {
        return this.implementationDetails;
    }

    public RecommendedActionErrorInfo errorDetails() {
        return this.errorDetails;
    }

    public List<RecommendedActionImpactRecord> estimatedImpact() {
        return this.estimatedImpact;
    }

    public List<RecommendedActionImpactRecord> observedImpact() {
        return this.observedImpact;
    }

    public List<RecommendedActionMetricInfo> timeSeries() {
        return this.timeSeries;
    }

    public List<String> linkedObjects() {
        return this.linkedObjects;
    }

    public Map<String, Object> details() {
        return this.details;
    }

    public void validate() {
        if (this.state() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property state in model RecommendedActionProperties"));
        }
        this.state().validate();
        if (this.implementationDetails() != null) {
            this.implementationDetails().validate();
        }
        if (this.errorDetails() != null) {
            this.errorDetails().validate();
        }
        if (this.estimatedImpact() != null) {
            this.estimatedImpact().forEach(e -> e.validate());
        }
        if (this.observedImpact() != null) {
            this.observedImpact().forEach(e -> e.validate());
        }
        if (this.timeSeries() != null) {
            this.timeSeries().forEach(e -> e.validate());
        }
    }
}

