/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.DatabaseEncryptionProtectorsClient;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.EncryptionProtectorName;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DatabaseEncryptionProtectorsClientImpl
implements DatabaseEncryptionProtectorsClient {
    private final DatabaseEncryptionProtectorsService service;
    private final SqlManagementClientImpl client;

    DatabaseEncryptionProtectorsClientImpl(SqlManagementClientImpl client) {
        this.service = (DatabaseEncryptionProtectorsService)RestProxy.create(DatabaseEncryptionProtectorsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> revalidateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (encryptionProtectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionProtectorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-08-01-preview";
        return FluxUtil.withContext(context -> this.service.revalidate(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, encryptionProtectorName, this.client.getSubscriptionId(), "2022-08-01-preview", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> revalidateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (encryptionProtectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionProtectorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-08-01-preview";
        context = this.client.mergeContext(context);
        return this.service.revalidate(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, encryptionProtectorName, this.client.getSubscriptionId(), "2022-08-01-preview", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRevalidateAsync(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.revalidateWithResponseAsync(resourceGroupName, serverName, databaseName, encryptionProtectorName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRevalidateAsync(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.revalidateWithResponseAsync(resourceGroupName, serverName, databaseName, encryptionProtectorName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRevalidate(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName) {
        return this.beginRevalidateAsync(resourceGroupName, serverName, databaseName, encryptionProtectorName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRevalidate(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName, Context context) {
        return this.beginRevalidateAsync(resourceGroupName, serverName, databaseName, encryptionProtectorName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> revalidateAsync(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName) {
        return this.beginRevalidateAsync(resourceGroupName, serverName, databaseName, encryptionProtectorName).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> revalidateAsync(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName, Context context) {
        return this.beginRevalidateAsync(resourceGroupName, serverName, databaseName, encryptionProtectorName, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void revalidate(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName) {
        this.revalidateAsync(resourceGroupName, serverName, databaseName, encryptionProtectorName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void revalidate(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName, Context context) {
        this.revalidateAsync(resourceGroupName, serverName, databaseName, encryptionProtectorName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> revertWithResponseAsync(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (encryptionProtectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionProtectorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-08-01-preview";
        return FluxUtil.withContext(context -> this.service.revert(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, encryptionProtectorName, this.client.getSubscriptionId(), "2022-08-01-preview", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> revertWithResponseAsync(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (encryptionProtectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionProtectorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-08-01-preview";
        context = this.client.mergeContext(context);
        return this.service.revert(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, encryptionProtectorName, this.client.getSubscriptionId(), "2022-08-01-preview", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRevertAsync(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.revertWithResponseAsync(resourceGroupName, serverName, databaseName, encryptionProtectorName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRevertAsync(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.revertWithResponseAsync(resourceGroupName, serverName, databaseName, encryptionProtectorName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRevert(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName) {
        return this.beginRevertAsync(resourceGroupName, serverName, databaseName, encryptionProtectorName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRevert(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName, Context context) {
        return this.beginRevertAsync(resourceGroupName, serverName, databaseName, encryptionProtectorName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> revertAsync(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName) {
        return this.beginRevertAsync(resourceGroupName, serverName, databaseName, encryptionProtectorName).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> revertAsync(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName, Context context) {
        return this.beginRevertAsync(resourceGroupName, serverName, databaseName, encryptionProtectorName, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void revert(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName) {
        this.revertAsync(resourceGroupName, serverName, databaseName, encryptionProtectorName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void revert(String resourceGroupName, String serverName, String databaseName, EncryptionProtectorName encryptionProtectorName, Context context) {
        this.revertAsync(resourceGroupName, serverName, databaseName, encryptionProtectorName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientD")
    public static interface DatabaseEncryptionProtectorsService {
        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/encryptionProtector/{encryptionProtectorName}/revalidate")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> revalidate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="encryptionProtectorName") EncryptionProtectorName var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/encryptionProtector/{encryptionProtectorName}/revert")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> revert(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="encryptionProtectorName") EncryptionProtectorName var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, Context var8);
    }
}

