/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.MaintenanceWindowsOperationsClient;
import com.azure.resourcemanager.sql.fluent.models.MaintenanceWindowsInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import reactor.core.publisher.Mono;

public final class MaintenanceWindowsOperationsClientImpl
implements MaintenanceWindowsOperationsClient {
    private final MaintenanceWindowsOperationsService service;
    private final SqlManagementClientImpl client;

    MaintenanceWindowsOperationsClientImpl(SqlManagementClientImpl client) {
        this.service = (MaintenanceWindowsOperationsService)RestProxy.create(MaintenanceWindowsOperationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MaintenanceWindowsInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, String maintenanceWindowName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (maintenanceWindowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter maintenanceWindowName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, maintenanceWindowName, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MaintenanceWindowsInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, String maintenanceWindowName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (maintenanceWindowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter maintenanceWindowName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, maintenanceWindowName, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MaintenanceWindowsInner> getAsync(String resourceGroupName, String serverName, String databaseName, String maintenanceWindowName) {
        return this.getWithResponseAsync(resourceGroupName, serverName, databaseName, maintenanceWindowName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((MaintenanceWindowsInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MaintenanceWindowsInner> getWithResponse(String resourceGroupName, String serverName, String databaseName, String maintenanceWindowName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, databaseName, maintenanceWindowName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MaintenanceWindowsInner get(String resourceGroupName, String serverName, String databaseName, String maintenanceWindowName) {
        return (MaintenanceWindowsInner)((Object)this.getWithResponse(resourceGroupName, serverName, databaseName, maintenanceWindowName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, String maintenanceWindowName, MaintenanceWindowsInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (maintenanceWindowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter maintenanceWindowName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-11-01-preview";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, maintenanceWindowName, this.client.getSubscriptionId(), "2020-11-01-preview", parameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, String maintenanceWindowName, MaintenanceWindowsInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (maintenanceWindowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter maintenanceWindowName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-11-01-preview";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, maintenanceWindowName, this.client.getSubscriptionId(), "2020-11-01-preview", parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String maintenanceWindowName, MaintenanceWindowsInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, maintenanceWindowName, parameters).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createOrUpdateWithResponse(String resourceGroupName, String serverName, String databaseName, String maintenanceWindowName, MaintenanceWindowsInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, maintenanceWindowName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createOrUpdate(String resourceGroupName, String serverName, String databaseName, String maintenanceWindowName, MaintenanceWindowsInner parameters) {
        this.createOrUpdateWithResponse(resourceGroupName, serverName, databaseName, maintenanceWindowName, parameters, Context.NONE);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientM")
    public static interface MaintenanceWindowsOperationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/maintenanceWindows/current")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MaintenanceWindowsInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @QueryParam(value="maintenanceWindowName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/maintenanceWindows/current")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @QueryParam(value="maintenanceWindowName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") MaintenanceWindowsInner var8, Context var9);
    }
}

