/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.ManagedDatabaseMoveOperationsClient;
import com.azure.resourcemanager.sql.fluent.models.ManagedDatabaseMoveOperationResultInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.ManagedDatabaseMoveOperationListResult;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class ManagedDatabaseMoveOperationsClientImpl
implements ManagedDatabaseMoveOperationsClient {
    private final ManagedDatabaseMoveOperationsService service;
    private final SqlManagementClientImpl client;

    ManagedDatabaseMoveOperationsClientImpl(SqlManagementClientImpl client) {
        this.service = (ManagedDatabaseMoveOperationsService)RestProxy.create(ManagedDatabaseMoveOperationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedDatabaseMoveOperationResultInner>> listByLocationSinglePageAsync(String resourceGroupName, String locationName, Boolean onlyLatestPerDatabase, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-05-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByLocation(this.client.getEndpoint(), resourceGroupName, locationName, onlyLatestPerDatabase, filter, this.client.getSubscriptionId(), "2022-05-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedDatabaseMoveOperationListResult)res.getValue()).value(), ((ManagedDatabaseMoveOperationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedDatabaseMoveOperationResultInner>> listByLocationSinglePageAsync(String resourceGroupName, String locationName, Boolean onlyLatestPerDatabase, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-05-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByLocation(this.client.getEndpoint(), resourceGroupName, locationName, onlyLatestPerDatabase, filter, this.client.getSubscriptionId(), "2022-05-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedDatabaseMoveOperationListResult)res.getValue()).value(), ((ManagedDatabaseMoveOperationListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ManagedDatabaseMoveOperationResultInner> listByLocationAsync(String resourceGroupName, String locationName, Boolean onlyLatestPerDatabase, String filter) {
        return new PagedFlux(() -> this.listByLocationSinglePageAsync(resourceGroupName, locationName, onlyLatestPerDatabase, filter), nextLink -> this.listByLocationNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ManagedDatabaseMoveOperationResultInner> listByLocationAsync(String resourceGroupName, String locationName) {
        Boolean onlyLatestPerDatabase = null;
        String filter = null;
        return new PagedFlux(() -> this.listByLocationSinglePageAsync(resourceGroupName, locationName, onlyLatestPerDatabase, filter), nextLink -> this.listByLocationNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ManagedDatabaseMoveOperationResultInner> listByLocationAsync(String resourceGroupName, String locationName, Boolean onlyLatestPerDatabase, String filter, Context context) {
        return new PagedFlux(() -> this.listByLocationSinglePageAsync(resourceGroupName, locationName, onlyLatestPerDatabase, filter, context), nextLink -> this.listByLocationNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedDatabaseMoveOperationResultInner> listByLocation(String resourceGroupName, String locationName) {
        Boolean onlyLatestPerDatabase = null;
        String filter = null;
        return new PagedIterable(this.listByLocationAsync(resourceGroupName, locationName, onlyLatestPerDatabase, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedDatabaseMoveOperationResultInner> listByLocation(String resourceGroupName, String locationName, Boolean onlyLatestPerDatabase, String filter, Context context) {
        return new PagedIterable(this.listByLocationAsync(resourceGroupName, locationName, onlyLatestPerDatabase, filter, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ManagedDatabaseMoveOperationResultInner>> getWithResponseAsync(String resourceGroupName, String locationName, UUID operationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-05-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, locationName, operationId, this.client.getSubscriptionId(), "2022-05-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ManagedDatabaseMoveOperationResultInner>> getWithResponseAsync(String resourceGroupName, String locationName, UUID operationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-05-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, locationName, operationId, this.client.getSubscriptionId(), "2022-05-01-preview", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ManagedDatabaseMoveOperationResultInner> getAsync(String resourceGroupName, String locationName, UUID operationId) {
        return this.getWithResponseAsync(resourceGroupName, locationName, operationId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ManagedDatabaseMoveOperationResultInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ManagedDatabaseMoveOperationResultInner> getWithResponse(String resourceGroupName, String locationName, UUID operationId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, locationName, operationId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedDatabaseMoveOperationResultInner get(String resourceGroupName, String locationName, UUID operationId) {
        return (ManagedDatabaseMoveOperationResultInner)((Object)this.getWithResponse(resourceGroupName, locationName, operationId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedDatabaseMoveOperationResultInner>> listByLocationNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByLocationNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedDatabaseMoveOperationListResult)res.getValue()).value(), ((ManagedDatabaseMoveOperationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedDatabaseMoveOperationResultInner>> listByLocationNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByLocationNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedDatabaseMoveOperationListResult)res.getValue()).value(), ((ManagedDatabaseMoveOperationListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientM")
    public static interface ManagedDatabaseMoveOperationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/managedDatabaseMoveOperationResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedDatabaseMoveOperationListResult>> listByLocation(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="locationName") String var3, @QueryParam(value="onlyLatestPerDatabase") Boolean var4, @QueryParam(value="$filter") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/managedDatabaseMoveOperationResults/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedDatabaseMoveOperationResultInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="locationName") String var3, @PathParam(value="operationId") UUID var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedDatabaseMoveOperationListResult>> listByLocationNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

