/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.SqlVulnerabilityAssessmentScansClient;
import com.azure.resourcemanager.sql.fluent.models.SqlVulnerabilityAssessmentScanRecordInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.SqlVulnerabilityAssessmentScanRecordListResult;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentName;
import reactor.core.publisher.Mono;

public final class SqlVulnerabilityAssessmentScansClientImpl
implements SqlVulnerabilityAssessmentScansClient {
    private final SqlVulnerabilityAssessmentScansService service;
    private final SqlManagementClientImpl client;

    SqlVulnerabilityAssessmentScansClientImpl(SqlManagementClientImpl client) {
        this.service = (SqlVulnerabilityAssessmentScansService)RestProxy.create(SqlVulnerabilityAssessmentScansService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SqlVulnerabilityAssessmentScanRecordInner>> listBySqlVulnerabilityAssessmentsSinglePageAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String systemDatabaseName = "master";
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySqlVulnerabilityAssessments(this.client.getEndpoint(), resourceGroupName, serverName, vulnerabilityAssessmentName, "master", this.client.getSubscriptionId(), "2022-11-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlVulnerabilityAssessmentScanRecordListResult)res.getValue()).value(), ((SqlVulnerabilityAssessmentScanRecordListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SqlVulnerabilityAssessmentScanRecordInner>> listBySqlVulnerabilityAssessmentsSinglePageAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String systemDatabaseName = "master";
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySqlVulnerabilityAssessments(this.client.getEndpoint(), resourceGroupName, serverName, vulnerabilityAssessmentName, "master", this.client.getSubscriptionId(), "2022-11-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlVulnerabilityAssessmentScanRecordListResult)res.getValue()).value(), ((SqlVulnerabilityAssessmentScanRecordListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SqlVulnerabilityAssessmentScanRecordInner> listBySqlVulnerabilityAssessmentsAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        return new PagedFlux(() -> this.listBySqlVulnerabilityAssessmentsSinglePageAsync(resourceGroupName, serverName, vulnerabilityAssessmentName), nextLink -> this.listBySqlVulnerabilityAssessmentsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SqlVulnerabilityAssessmentScanRecordInner> listBySqlVulnerabilityAssessmentsAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        return new PagedFlux(() -> this.listBySqlVulnerabilityAssessmentsSinglePageAsync(resourceGroupName, serverName, vulnerabilityAssessmentName, context), nextLink -> this.listBySqlVulnerabilityAssessmentsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SqlVulnerabilityAssessmentScanRecordInner> listBySqlVulnerabilityAssessments(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        return new PagedIterable(this.listBySqlVulnerabilityAssessmentsAsync(resourceGroupName, serverName, vulnerabilityAssessmentName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SqlVulnerabilityAssessmentScanRecordInner> listBySqlVulnerabilityAssessments(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        return new PagedIterable(this.listBySqlVulnerabilityAssessmentsAsync(resourceGroupName, serverName, vulnerabilityAssessmentName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SqlVulnerabilityAssessmentScanRecordInner>> getWithResponseAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String systemDatabaseName = "master";
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, vulnerabilityAssessmentName, scanId, "master", this.client.getSubscriptionId(), "2022-11-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SqlVulnerabilityAssessmentScanRecordInner>> getWithResponseAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String systemDatabaseName = "master";
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, vulnerabilityAssessmentName, scanId, "master", this.client.getSubscriptionId(), "2022-11-01-preview", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlVulnerabilityAssessmentScanRecordInner> getAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return this.getWithResponseAsync(resourceGroupName, serverName, vulnerabilityAssessmentName, scanId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SqlVulnerabilityAssessmentScanRecordInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SqlVulnerabilityAssessmentScanRecordInner> getWithResponse(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, vulnerabilityAssessmentName, scanId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlVulnerabilityAssessmentScanRecordInner get(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return (SqlVulnerabilityAssessmentScanRecordInner)((Object)this.getWithResponse(resourceGroupName, serverName, vulnerabilityAssessmentName, scanId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SqlVulnerabilityAssessmentScanRecordInner>> listBySqlVulnerabilityAssessmentsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySqlVulnerabilityAssessmentsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlVulnerabilityAssessmentScanRecordListResult)res.getValue()).value(), ((SqlVulnerabilityAssessmentScanRecordListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SqlVulnerabilityAssessmentScanRecordInner>> listBySqlVulnerabilityAssessmentsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySqlVulnerabilityAssessmentsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlVulnerabilityAssessmentScanRecordListResult)res.getValue()).value(), ((SqlVulnerabilityAssessmentScanRecordListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientS")
    public static interface SqlVulnerabilityAssessmentScansService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlVulnerabilityAssessmentScanRecordListResult>> listBySqlVulnerabilityAssessments(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var4, @QueryParam(value="systemDatabaseName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlVulnerabilityAssessmentScanRecordInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var4, @PathParam(value="scanId") String var5, @QueryParam(value="systemDatabaseName") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlVulnerabilityAssessmentScanRecordListResult>> listBySqlVulnerabilityAssessmentsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

