/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.SqlVulnerabilityAssessmentsSettingsClient;
import com.azure.resourcemanager.sql.fluent.models.SqlVulnerabilityAssessmentInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.SqlVulnerabilityAssessmentListResult;
import com.azure.resourcemanager.sql.models.SqlVulnerabilityAssessmentName;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentName;
import reactor.core.publisher.Mono;

public final class SqlVulnerabilityAssessmentsSettingsClientImpl
implements SqlVulnerabilityAssessmentsSettingsClient {
    private final SqlVulnerabilityAssessmentsSettingsService service;
    private final SqlManagementClientImpl client;

    SqlVulnerabilityAssessmentsSettingsClientImpl(SqlManagementClientImpl client) {
        this.service = (SqlVulnerabilityAssessmentsSettingsService)RestProxy.create(SqlVulnerabilityAssessmentsSettingsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SqlVulnerabilityAssessmentInner>> listByServerSinglePageAsync(String resourceGroupName, String serverName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByServer(this.client.getEndpoint(), resourceGroupName, serverName, this.client.getSubscriptionId(), "2022-11-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlVulnerabilityAssessmentListResult)res.getValue()).value(), ((SqlVulnerabilityAssessmentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SqlVulnerabilityAssessmentInner>> listByServerSinglePageAsync(String resourceGroupName, String serverName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByServer(this.client.getEndpoint(), resourceGroupName, serverName, this.client.getSubscriptionId(), "2022-11-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlVulnerabilityAssessmentListResult)res.getValue()).value(), ((SqlVulnerabilityAssessmentListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SqlVulnerabilityAssessmentInner> listByServerAsync(String resourceGroupName, String serverName) {
        return new PagedFlux(() -> this.listByServerSinglePageAsync(resourceGroupName, serverName), nextLink -> this.listByServerNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SqlVulnerabilityAssessmentInner> listByServerAsync(String resourceGroupName, String serverName, Context context) {
        return new PagedFlux(() -> this.listByServerSinglePageAsync(resourceGroupName, serverName, context), nextLink -> this.listByServerNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SqlVulnerabilityAssessmentInner> listByServer(String resourceGroupName, String serverName) {
        return new PagedIterable(this.listByServerAsync(resourceGroupName, serverName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SqlVulnerabilityAssessmentInner> listByServer(String resourceGroupName, String serverName, Context context) {
        return new PagedIterable(this.listByServerAsync(resourceGroupName, serverName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SqlVulnerabilityAssessmentInner>> getWithResponseAsync(String resourceGroupName, String serverName, SqlVulnerabilityAssessmentName vulnerabilityAssessmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, vulnerabilityAssessmentName, this.client.getSubscriptionId(), "2022-11-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SqlVulnerabilityAssessmentInner>> getWithResponseAsync(String resourceGroupName, String serverName, SqlVulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, vulnerabilityAssessmentName, this.client.getSubscriptionId(), "2022-11-01-preview", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String serverName, SqlVulnerabilityAssessmentName vulnerabilityAssessmentName) {
        return this.getWithResponseAsync(resourceGroupName, serverName, vulnerabilityAssessmentName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SqlVulnerabilityAssessmentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SqlVulnerabilityAssessmentInner> getWithResponse(String resourceGroupName, String serverName, SqlVulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, vulnerabilityAssessmentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlVulnerabilityAssessmentInner get(String resourceGroupName, String serverName, SqlVulnerabilityAssessmentName vulnerabilityAssessmentName) {
        return (SqlVulnerabilityAssessmentInner)((Object)this.getWithResponse(resourceGroupName, serverName, vulnerabilityAssessmentName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SqlVulnerabilityAssessmentInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, vulnerabilityAssessmentName, this.client.getSubscriptionId(), "2022-11-01-preview", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SqlVulnerabilityAssessmentInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, vulnerabilityAssessmentName, this.client.getSubscriptionId(), "2022-11-01-preview", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, vulnerabilityAssessmentName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SqlVulnerabilityAssessmentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SqlVulnerabilityAssessmentInner> createOrUpdateWithResponse(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, vulnerabilityAssessmentName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlVulnerabilityAssessmentInner createOrUpdate(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentInner parameters) {
        return (SqlVulnerabilityAssessmentInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, serverName, vulnerabilityAssessmentName, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SqlVulnerabilityAssessmentInner>> listByServerNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByServerNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlVulnerabilityAssessmentListResult)res.getValue()).value(), ((SqlVulnerabilityAssessmentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SqlVulnerabilityAssessmentInner>> listByServerNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByServerNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlVulnerabilityAssessmentListResult)res.getValue()).value(), ((SqlVulnerabilityAssessmentListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientS")
    public static interface SqlVulnerabilityAssessmentsSettingsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlVulnerabilityAssessmentListResult>> listByServer(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlVulnerabilityAssessmentInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="vulnerabilityAssessmentName") SqlVulnerabilityAssessmentName var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlVulnerabilityAssessmentInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") SqlVulnerabilityAssessmentInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlVulnerabilityAssessmentListResult>> listByServerNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

