/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.resourcemanager.sql.models.DatabaseIdentityType;
import com.azure.resourcemanager.sql.models.DatabaseUserIdentity;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.UUID;

public final class DatabaseIdentity {
    @JsonProperty(value="type")
    private DatabaseIdentityType type;
    @JsonProperty(value="tenantId", access=JsonProperty.Access.WRITE_ONLY)
    private UUID tenantId;
    @JsonProperty(value="userAssignedIdentities")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, DatabaseUserIdentity> userAssignedIdentities;

    public DatabaseIdentityType type() {
        return this.type;
    }

    public DatabaseIdentity withType(DatabaseIdentityType type) {
        this.type = type;
        return this;
    }

    public UUID tenantId() {
        return this.tenantId;
    }

    public Map<String, DatabaseUserIdentity> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public DatabaseIdentity withUserAssignedIdentities(Map<String, DatabaseUserIdentity> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }
}

