/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.NetworkIsolationSettings;
import com.azure.resourcemanager.sql.models.StorageKeyType;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ImportNewDatabaseDefinition {
    @JsonProperty(value="databaseName")
    private String databaseName;
    @JsonProperty(value="edition")
    private String edition;
    @JsonProperty(value="serviceObjectiveName")
    private String serviceObjectiveName;
    @JsonProperty(value="maxSizeBytes")
    private String maxSizeBytes;
    @JsonProperty(value="storageKeyType", required=true)
    private StorageKeyType storageKeyType;
    @JsonProperty(value="storageKey", required=true)
    private String storageKey;
    @JsonProperty(value="storageUri", required=true)
    private String storageUri;
    @JsonProperty(value="administratorLogin", required=true)
    private String administratorLogin;
    @JsonProperty(value="administratorLoginPassword")
    private String administratorLoginPassword;
    @JsonProperty(value="authenticationType")
    private String authenticationType;
    @JsonProperty(value="networkIsolation")
    private NetworkIsolationSettings networkIsolation;
    private static final ClientLogger LOGGER = new ClientLogger(ImportNewDatabaseDefinition.class);

    public String databaseName() {
        return this.databaseName;
    }

    public ImportNewDatabaseDefinition withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public String edition() {
        return this.edition;
    }

    public ImportNewDatabaseDefinition withEdition(String edition) {
        this.edition = edition;
        return this;
    }

    public String serviceObjectiveName() {
        return this.serviceObjectiveName;
    }

    public ImportNewDatabaseDefinition withServiceObjectiveName(String serviceObjectiveName) {
        this.serviceObjectiveName = serviceObjectiveName;
        return this;
    }

    public String maxSizeBytes() {
        return this.maxSizeBytes;
    }

    public ImportNewDatabaseDefinition withMaxSizeBytes(String maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    public StorageKeyType storageKeyType() {
        return this.storageKeyType;
    }

    public ImportNewDatabaseDefinition withStorageKeyType(StorageKeyType storageKeyType) {
        this.storageKeyType = storageKeyType;
        return this;
    }

    public String storageKey() {
        return this.storageKey;
    }

    public ImportNewDatabaseDefinition withStorageKey(String storageKey) {
        this.storageKey = storageKey;
        return this;
    }

    public String storageUri() {
        return this.storageUri;
    }

    public ImportNewDatabaseDefinition withStorageUri(String storageUri) {
        this.storageUri = storageUri;
        return this;
    }

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ImportNewDatabaseDefinition withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ImportNewDatabaseDefinition withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public String authenticationType() {
        return this.authenticationType;
    }

    public ImportNewDatabaseDefinition withAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public NetworkIsolationSettings networkIsolation() {
        return this.networkIsolation;
    }

    public ImportNewDatabaseDefinition withNetworkIsolation(NetworkIsolationSettings networkIsolation) {
        this.networkIsolation = networkIsolation;
        return this;
    }

    public void validate() {
        if (this.storageKeyType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageKeyType in model ImportNewDatabaseDefinition"));
        }
        if (this.storageKey() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageKey in model ImportNewDatabaseDefinition"));
        }
        if (this.storageUri() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageUri in model ImportNewDatabaseDefinition"));
        }
        if (this.administratorLogin() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property administratorLogin in model ImportNewDatabaseDefinition"));
        }
        if (this.administratorLoginPassword() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property administratorLoginPassword in model ImportNewDatabaseDefinition"));
        }
        if (this.networkIsolation() != null) {
            this.networkIsolation().validate();
        }
    }
}

