/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.DataMaskingFunction;
import com.azure.resourcemanager.sql.models.DataMaskingRuleState;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class DataMaskingRuleProperties {
    @JsonProperty(value="id", access=JsonProperty.Access.WRITE_ONLY)
    private String id;
    @JsonProperty(value="ruleState")
    private DataMaskingRuleState ruleState;
    @JsonProperty(value="schemaName", required=true)
    private String schemaName;
    @JsonProperty(value="tableName", required=true)
    private String tableName;
    @JsonProperty(value="columnName", required=true)
    private String columnName;
    @JsonProperty(value="aliasName")
    private String aliasName;
    @JsonProperty(value="maskingFunction", required=true)
    private DataMaskingFunction maskingFunction;
    @JsonProperty(value="numberFrom")
    private String numberFrom;
    @JsonProperty(value="numberTo")
    private String numberTo;
    @JsonProperty(value="prefixSize")
    private String prefixSize;
    @JsonProperty(value="suffixSize")
    private String suffixSize;
    @JsonProperty(value="replacementString")
    private String replacementString;
    private static final ClientLogger LOGGER = new ClientLogger(DataMaskingRuleProperties.class);

    public String id() {
        return this.id;
    }

    public DataMaskingRuleState ruleState() {
        return this.ruleState;
    }

    public DataMaskingRuleProperties withRuleState(DataMaskingRuleState ruleState) {
        this.ruleState = ruleState;
        return this;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public DataMaskingRuleProperties withSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public String tableName() {
        return this.tableName;
    }

    public DataMaskingRuleProperties withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String columnName() {
        return this.columnName;
    }

    public DataMaskingRuleProperties withColumnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    public String aliasName() {
        return this.aliasName;
    }

    public DataMaskingRuleProperties withAliasName(String aliasName) {
        this.aliasName = aliasName;
        return this;
    }

    public DataMaskingFunction maskingFunction() {
        return this.maskingFunction;
    }

    public DataMaskingRuleProperties withMaskingFunction(DataMaskingFunction maskingFunction) {
        this.maskingFunction = maskingFunction;
        return this;
    }

    public String numberFrom() {
        return this.numberFrom;
    }

    public DataMaskingRuleProperties withNumberFrom(String numberFrom) {
        this.numberFrom = numberFrom;
        return this;
    }

    public String numberTo() {
        return this.numberTo;
    }

    public DataMaskingRuleProperties withNumberTo(String numberTo) {
        this.numberTo = numberTo;
        return this;
    }

    public String prefixSize() {
        return this.prefixSize;
    }

    public DataMaskingRuleProperties withPrefixSize(String prefixSize) {
        this.prefixSize = prefixSize;
        return this;
    }

    public String suffixSize() {
        return this.suffixSize;
    }

    public DataMaskingRuleProperties withSuffixSize(String suffixSize) {
        this.suffixSize = suffixSize;
        return this;
    }

    public String replacementString() {
        return this.replacementString;
    }

    public DataMaskingRuleProperties withReplacementString(String replacementString) {
        this.replacementString = replacementString;
        return this;
    }

    public void validate() {
        if (this.schemaName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property schemaName in model DataMaskingRuleProperties"));
        }
        if (this.tableName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property tableName in model DataMaskingRuleProperties"));
        }
        if (this.columnName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property columnName in model DataMaskingRuleProperties"));
        }
        if (this.maskingFunction() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property maskingFunction in model DataMaskingRuleProperties"));
        }
    }
}

