// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.sql.fluent.models.DatabaseVulnerabilityAssessmentScansExportInner;
import com.azure.resourcemanager.sql.fluent.models.VulnerabilityAssessmentScanRecordInner;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentName;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * DatabaseVulnerabilityAssessmentScansClient.
 */
public interface DatabaseVulnerabilityAssessmentScansClient {
    /**
     * Lists the vulnerability assessment scans of a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of vulnerability assessment scan records as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<VulnerabilityAssessmentScanRecordInner> listByDatabaseAsync(
        String resourceGroupName,
        String serverName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName);

    /**
     * Lists the vulnerability assessment scans of a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of vulnerability assessment scan records as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VulnerabilityAssessmentScanRecordInner> listByDatabase(
        String resourceGroupName,
        String serverName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName);

    /**
     * Lists the vulnerability assessment scans of a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of vulnerability assessment scan records as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VulnerabilityAssessmentScanRecordInner> listByDatabase(
        String resourceGroupName,
        String serverName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        Context context);

    /**
     * Gets a vulnerability assessment scan record of a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a vulnerability assessment scan record of a database along with {@link Response} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<VulnerabilityAssessmentScanRecordInner>> getWithResponseAsync(
        String resourceGroupName,
        String serverName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String scanId);

    /**
     * Gets a vulnerability assessment scan record of a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a vulnerability assessment scan record of a database on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VulnerabilityAssessmentScanRecordInner> getAsync(
        String resourceGroupName,
        String serverName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String scanId);

    /**
     * Gets a vulnerability assessment scan record of a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a vulnerability assessment scan record of a database along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<VulnerabilityAssessmentScanRecordInner> getWithResponse(
        String resourceGroupName,
        String serverName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String scanId,
        Context context);

    /**
     * Gets a vulnerability assessment scan record of a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a vulnerability assessment scan record of a database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VulnerabilityAssessmentScanRecordInner get(
        String resourceGroupName,
        String serverName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String scanId);

    /**
     * Convert an existing scan result to a human readable format. If already exists nothing happens.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the scanned database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database Vulnerability Assessment scan export resource along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DatabaseVulnerabilityAssessmentScansExportInner>> exportWithResponseAsync(
        String resourceGroupName,
        String serverName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String scanId);

    /**
     * Convert an existing scan result to a human readable format. If already exists nothing happens.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the scanned database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database Vulnerability Assessment scan export resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DatabaseVulnerabilityAssessmentScansExportInner> exportAsync(
        String resourceGroupName,
        String serverName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String scanId);

    /**
     * Convert an existing scan result to a human readable format. If already exists nothing happens.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the scanned database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database Vulnerability Assessment scan export resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DatabaseVulnerabilityAssessmentScansExportInner> exportWithResponse(
        String resourceGroupName,
        String serverName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String scanId,
        Context context);

    /**
     * Convert an existing scan result to a human readable format. If already exists nothing happens.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the scanned database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database Vulnerability Assessment scan export resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DatabaseVulnerabilityAssessmentScansExportInner export(
        String resourceGroupName,
        String serverName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String scanId);

    /**
     * Executes a Vulnerability Assessment database scan.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> initiateScanWithResponseAsync(
        String resourceGroupName,
        String serverName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String scanId);

    /**
     * Executes a Vulnerability Assessment database scan.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginInitiateScanAsync(
        String resourceGroupName,
        String serverName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String scanId);

    /**
     * Executes a Vulnerability Assessment database scan.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginInitiateScan(
        String resourceGroupName,
        String serverName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String scanId);

    /**
     * Executes a Vulnerability Assessment database scan.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginInitiateScan(
        String resourceGroupName,
        String serverName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String scanId,
        Context context);

    /**
     * Executes a Vulnerability Assessment database scan.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> initiateScanAsync(
        String resourceGroupName,
        String serverName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String scanId);

    /**
     * Executes a Vulnerability Assessment database scan.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void initiateScan(
        String resourceGroupName,
        String serverName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String scanId);

    /**
     * Executes a Vulnerability Assessment database scan.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void initiateScan(
        String resourceGroupName,
        String serverName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String scanId,
        Context context);
}
