// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.sql.fluent.models.ServerAdvancedThreatProtectionInner;
import com.azure.resourcemanager.sql.models.AdvancedThreatProtectionName;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * ServerAdvancedThreatProtectionSettingsClient.
 */
public interface ServerAdvancedThreatProtectionSettingsClient {
    /**
     * Get a list of the server's Advanced Threat Protection states.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of the server's Advanced Threat Protection states as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ServerAdvancedThreatProtectionInner> listByServerAsync(String resourceGroupName, String serverName);

    /**
     * Get a list of the server's Advanced Threat Protection states.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of the server's Advanced Threat Protection states as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ServerAdvancedThreatProtectionInner> listByServer(String resourceGroupName, String serverName);

    /**
     * Get a list of the server's Advanced Threat Protection states.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of the server's Advanced Threat Protection states as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ServerAdvancedThreatProtectionInner> listByServer(
        String resourceGroupName, String serverName, Context context);

    /**
     * Get a server's Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a server's Advanced Threat Protection state along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ServerAdvancedThreatProtectionInner>> getWithResponseAsync(
        String resourceGroupName, String serverName, AdvancedThreatProtectionName advancedThreatProtectionName);

    /**
     * Get a server's Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a server's Advanced Threat Protection state on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ServerAdvancedThreatProtectionInner> getAsync(
        String resourceGroupName, String serverName, AdvancedThreatProtectionName advancedThreatProtectionName);

    /**
     * Get a server's Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a server's Advanced Threat Protection state along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ServerAdvancedThreatProtectionInner> getWithResponse(
        String resourceGroupName,
        String serverName,
        AdvancedThreatProtectionName advancedThreatProtectionName,
        Context context);

    /**
     * Get a server's Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a server's Advanced Threat Protection state.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ServerAdvancedThreatProtectionInner get(
        String resourceGroupName, String serverName, AdvancedThreatProtectionName advancedThreatProtectionName);

    /**
     * Creates or updates an Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @param parameters The server Advanced Threat Protection state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a server Advanced Threat Protection along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String serverName,
        AdvancedThreatProtectionName advancedThreatProtectionName,
        ServerAdvancedThreatProtectionInner parameters);

    /**
     * Creates or updates an Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @param parameters The server Advanced Threat Protection state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a server Advanced Threat Protection.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<ServerAdvancedThreatProtectionInner>, ServerAdvancedThreatProtectionInner>
        beginCreateOrUpdateAsync(
            String resourceGroupName,
            String serverName,
            AdvancedThreatProtectionName advancedThreatProtectionName,
            ServerAdvancedThreatProtectionInner parameters);

    /**
     * Creates or updates an Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @param parameters The server Advanced Threat Protection state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a server Advanced Threat Protection.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ServerAdvancedThreatProtectionInner>, ServerAdvancedThreatProtectionInner>
        beginCreateOrUpdate(
            String resourceGroupName,
            String serverName,
            AdvancedThreatProtectionName advancedThreatProtectionName,
            ServerAdvancedThreatProtectionInner parameters);

    /**
     * Creates or updates an Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @param parameters The server Advanced Threat Protection state.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a server Advanced Threat Protection.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ServerAdvancedThreatProtectionInner>, ServerAdvancedThreatProtectionInner>
        beginCreateOrUpdate(
            String resourceGroupName,
            String serverName,
            AdvancedThreatProtectionName advancedThreatProtectionName,
            ServerAdvancedThreatProtectionInner parameters,
            Context context);

    /**
     * Creates or updates an Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @param parameters The server Advanced Threat Protection state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a server Advanced Threat Protection on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ServerAdvancedThreatProtectionInner> createOrUpdateAsync(
        String resourceGroupName,
        String serverName,
        AdvancedThreatProtectionName advancedThreatProtectionName,
        ServerAdvancedThreatProtectionInner parameters);

    /**
     * Creates or updates an Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @param parameters The server Advanced Threat Protection state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a server Advanced Threat Protection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ServerAdvancedThreatProtectionInner createOrUpdate(
        String resourceGroupName,
        String serverName,
        AdvancedThreatProtectionName advancedThreatProtectionName,
        ServerAdvancedThreatProtectionInner parameters);

    /**
     * Creates or updates an Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @param parameters The server Advanced Threat Protection state.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a server Advanced Threat Protection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ServerAdvancedThreatProtectionInner createOrUpdate(
        String resourceGroupName,
        String serverName,
        AdvancedThreatProtectionName advancedThreatProtectionName,
        ServerAdvancedThreatProtectionInner parameters,
        Context context);
}
